import AvatarComp from '../../../../../../components/BaseCompontents/AvatarCompForRandom';
import useResizeAware from '../../../../../../hooks/useResizeAware';
import { ISpeaker } from '../../../../../../pages/docASR/components/atomicComponent/WuLab';
import { getDefaultName } from '../../../../../../utils/speakerUtils';
import { message, Tooltip } from '@tingwu/design';
import React from 'react';
import styled from 'styled-components';
import { QAInfoType } from './qaBean';

const QuestionAnswerItemContainer = styled.div`
  padding: 16px;
  display: flex;
  background: rgba(96, 92, 229, 0.05);
  border-radius: 4px;
  margin-bottom: 12px;
  user-select: none;
  cursor: pointer;
  :hover {
    background: rgba(96, 92, 229, 0.1);
  }
  .questionAnswerItem-text {
    font-family: PingFangSC, var(--font-family);
    font-size: 14px;
    color: rgba(39, 38, 77, 0.85);
    letter-spacing: 0;
    line-height: 24px;
    margin-left: 12px;
    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
  }
  .questionAnswerItem-q {
    height: 16px;
    width: 23px;
    background-color: #615ced;
    border-radius: 2px;
    display: inline-block;
    color: #fff;
    font-size: 12px;
    line-height: 16px;
    padding-left: 3px;
    margin-right: 5px;
  }
`;
const QuestionAnswerItem = ({
  question,
  choose,
  searchValue,
  speakers,
  roleSplitTipStatus,
  alls,
  onChoose,
  transId,
}: // index,
{
  question: QAInfoType;
  choose: boolean;
  searchValue: string;
  speakers: ISpeaker[];
  roleSplitTipStatus: boolean;
  alls: boolean;
  transId: string;
  onChoose?: (info: QAInfoType) => void;
  // index: number;
}) => {
  const ref: any = React.useRef();
  const [tipsZindex, setTipsZindex] = React.useState(-1);
  const [resizeListener, sizes] = useResizeAware();
  const text = question.question.title;
  const html: any = [];
  const value = doubleDollarChar(searchValue);
  getHighLightFragments(text, searchValue).forEach((res) => {
    if (res.isKeyword) {
      html.push(<span style={{ background: '#FFDFA4' }}>{value}</span>);
    } else {
      html.push(res.title);
    }
  });

  const _speaker = speakers.find(
    (speaker) => speaker.ui === question.question.uid,
  );
  const avatarUrl = speakers.find(
    (speaker) => speaker.ui === question.question.uid,
  )?.avatarUrl;
  const getBc = () => {
    return choose
      ? { background: 'rgba(96,92,229,.1)', fontWeight: 'bold' }
      : { fontWeight: 400 };
  };

  React.useEffect(() => {
    if (alls && ref.current) {
      setTimeout(() => {
        if (ref.current?.scrollHeight > ref.current?.clientHeight) {
          setTipsZindex(1000);
        } else {
          setTipsZindex(-1);
        }
      }, 0);
    }
  }, [alls, ref, ref.current, sizes]);

  return (
    <Tooltip
      title={text}
      overlayClassName="tingwu2-tips"
      placement="right"
      zIndex={tipsZindex}
    >
      <QuestionAnswerItemContainer
        style={
          question.isVaild
            ? getBc()
            : { background: 'rgba(96,92,229,0.05)', cursor: 'not-allowed' }
        }
        onClick={() => {
          if (!question.isVaild) {
            message.warning('该问题对应的原文内容已被删除，无法回顾');
          } else {
            onChoose && onChoose(question);
          }
        }}
      >
        {/* 监听容器宽高 */}
        {resizeListener as any}
        <AvatarComp
          avaTextOrign={_speaker?.name || question.question.uid || '0'}
          // realName={name !== undefined && name !== ''}
          nameId={_speaker?.nameAvaId}
          sizeStyle={24}
          nameSizeStyle={14}
          avatarUrl={avatarUrl}
          defaultSpeakerStatus={
            _speaker?.name
              ? false
              : getDefaultName(question.question.uid, roleSplitTipStatus) ===
                '发言人'
          }
        />
        <span
          className="questionAnswerItem-text"
          ref={ref}
          style={
            !question.isVaild
              ? { color: 'rgba(39,38,77,0.45)' }
              : { color: choose ? '#615ced' : 'rgba(39,38,77,0.85)' }
          }
        >
          <span className="questionAnswerItem-q">问:</span>
          {html}
        </span>
      </QuestionAnswerItemContainer>
    </Tooltip>
  );
};

export default QuestionAnswerItem;

const doubleDollarChar = (value: string) => {
  const values = value.split('');
  return values
    .map((item) => {
      return item === '$' ? '$$' : item;
    })
    .join('');
};

const getHighLightFragments = (src: any, keyword: string) => {
  const splits = src.split(keyword);
  const result: any[] = [];
  splits.forEach((title: string, index: number) => {
    result.push({
      title,
      isKeyword: false,
    });
    if (index < splits.length - 1) {
      result.push({
        title: keyword,
        isKeyword: true,
      });
    }
  }, result);
  return result;
};
