import { eTheme } from '../../../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import React, { memo, useCallback } from 'react';
import QnA from '../index.type';
import { QASummaryProps } from './index.type';
import QASummaryItem from './QASummaryItem';
import { QASummaryComp } from './styled';

// 问答回顾
const QASummary: React.FC<QASummaryProps> = memo((props) => {
  const { data, theme = eTheme.TAB_ITEM, unfold } = props;

  // 渲染要点部分
  const renderGistItem = useCallback(
    (qa: QnA, index) => {
      return (
        <QASummaryItem
          index={index}
          qa={qa}
          key={qa.id}
          clear={false}
          {...props}
        />
      );
    },
    [unfold, theme, props],
  );
  return (
    <QASummaryComp theme={theme}>{data?.map(renderGistItem)}</QASummaryComp>
  );
});

export default QASummary;
