import {
  docBaseHooks,
  docTagHooks,
  documentHooks,
  eDocScene,
} from '../../../../../../../../documentModel';
import { docSpeakerHooks } from '../../../../../../../../documentModel/docSpeaker';
import { SelectText } from '../../../../../../../../pages/docASR/components/atomicComponent/common/SelectText';
import { eTheme } from '../../../../../../../../pages/docASR/components/atomicComponent/WuLab/BigModel';
import classNames from 'classnames';
import { useCallback, useMemo } from 'react';
import { eEventTitle } from '../../../BigModel';
import { useSpeaker } from '../../../BIgModelInput/hooks/useSpeaker.hooks';
import { useReview } from '../../../hooks/useReview.hook';
import AvatarList from '../AvatarList';
import { GistItemProps } from './index.type';
import { GistItemComp } from './styled';

// 要点回顾
const GistItem = ({ theme = eTheme.TAB_ITEM, gist, index }: GistItemProps) => {
  const { docSpeakerData } = docSpeakerHooks.useDocSpeakerData();
  const { documentData } = documentHooks.useDocumentData();
  const { speakersSplitIsOpen } = docSpeakerData || {};
  const { docScene } = documentData || {};
  const { docTagData } = docTagHooks.useDocTagData();
  const { audioStatus } = (docTagData || {}) as any;
  const { onGistQAReviewHandle } = useReview();
  const { docBaseData } = docBaseHooks.useDocBaseData();

  // 发言人
  const { getAvatarNameList, getName } = useSpeaker();
  // 回顾/关闭回顾
  const reviewHandle = useCallback(
    (id) => {
      onGistQAReviewHandle(
        {
          eTitle: eEventTitle.REVIEW_HIGHLIGHTS_TAB,
          info: gist,
          sids: gist?.answer?.sids,
          id,
          index,
        },
        docBaseData?.consoleInfo?.taskSourceType,
      );
    },
    [onGistQAReviewHandle, index, docBaseData?.consoleInfo?.taskSourceType],
  );
  // 渲染发言人
  const renderSpokesman = useCallback(() => {
    return (
      <div className="GistItem__Spokesman">
        <div className={classNames('GistItem__Spokesman--Left')}>
          <AvatarList data={getAvatarNameList(gist.answer?.uids) as any} />
        </div>
        <div className="GistItem__Spokesman--Right">
          {getName(gist.answer?.uid)}
          {gist.answer?.isOnly ? '' : ' 等'}
        </div>
      </div>
    );
  }, [getAvatarNameList, getName, gist]);
  // 渲染右侧
  const renderGistItemRight = useMemo(() => {
    return (
      <div className="GistItem--Right">
        <div className="GistItem__Content--Top">
          <div className="GistItem__Title">{gist.question.title}</div>
        </div>
        <div className="GistItem__Content--Middle">{gist.answer?.title}</div>
        {speakersSplitIsOpen && gist.answer?.uid ? (
          <div className="GistItem__Content--Bottom">{renderSpokesman()}</div>
        ) : null}
      </div>
    );
  }, [speakersSplitIsOpen, renderSpokesman]);

  // 渲染左侧
  const renderGistItemLeft = useMemo(() => {
    return (
      <div className="GistItem--Left">
        <img
          className="GistItem__Icon"
          src="https://img.alicdn.com/imgextra/i1/O1CN01tCxocI1XYHXRh1ZkR_!!6000000002935-2-tps-80-48.png"
        />
      </div>
    );
  }, []);

  return (
    <SelectText
      onClick={() => {
        if (theme === eTheme.SUMMARY_ITEM || docScene !== eDocScene.discovery) {
          if (audioStatus === '0') {
            return;
          }
          reviewHandle(gist.id);
        }
      }}
    >
      <GistItemComp key={gist.id} theme={theme}>
        {renderGistItemLeft}
        {renderGistItemRight}
      </GistItemComp>
    </SelectText>
  );
};

export default GistItem;
