import styled from 'styled-components';

export const Container = styled.div`
  display: flex;
  width: 100%;
  padding: 10px 16px;
  border-radius: 8px;
  background: rgba(96, 92, 229, 0.05);

  /* background-image: url('https://img.alicdn.com/imgextra/i4/O1CN01590YrR1yCHu8VkK5B_!!6000000006542-2-tps-966-372.png'); */
  background-repeat: no-repeat;
  background-position: right;
  background-size: auto 100%;
`;

export const ImageContainerItem = styled.div`
  width: 100%;
  height: 100%;
  background: url('https://img.alicdn.com/imgextra/i4/O1CN01xEaU9i1QDU0GA6RNt_!!6000000001942-2-tps-276-276.png');
  background-size: contain;
  background-repeat: no-repeat;
`;

export const ImageContainer = styled.div<{ expanded: boolean }>`
  display: ${({ expanded }) => (expanded ? 'block' : 'none')};
  width: 92px;
  height: 92px;
  margin-top: 8px;
  margin-right: 16px;
`;

export const Content = styled.div`
  .ant-radio-wrapper {
    height: 20px;
    margin-right: 16px;

    .ant-radio {
      display: none;
      + * {
        padding: 0;
      }
    }
    .ant-radio + span {
      display: flex;
      align-items: center;
    }

    .tingwu-icon {
      margin-right: 6px;
    }
  }
`;

export const PPTTitle = styled.div`
  font-size: 14px;
  line-height: 24px;
  font-weight: 600;
  -webkit-font-smoothing: antialiased;
  color: #27264d;
  line-height: 24px;
  margin-bottom: 4px;
`;

export const PPTDes = styled.div`
  margin: 4px 0 6px 0;
  font-size: 12px;
  line-height: 20px;
  color: #72728b;
`;

export const IconContainer = styled.div`
  position: relative;
  display: inline-block;
  width: 12px;
  height: 100%;

  .tingwu-icon {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
  }
`;

export const RadioContainer = styled.div<{ loading: boolean }>`
  opacity: ${({ loading }) => (loading ? '0.3' : '1')};
`;

export const RadioTitle = styled.div`
  font-size: 12px;
  line-height: 20px;
  color: #27264d;
`;

export const ConfirmButton = styled.div<{ loading: boolean }>`
  cursor: pointer;
  display: ${({ loading }) => (loading ? 'none' : 'block')};
  margin-top: 6px;

  .ant-btn {
    height: 24px;
    width: 64px;
    min-width: 70px;
    padding: 2px 8px;
    font-size: 12px;
    border-color: #615ced;
    border-radius: 4px;
    color: #fff;
    background-color: #615ced;

    :hover {
      border-color: #7470e7;
      background-color: #7470e7;
      color: red;
    }
  }
`;

export const LoadingText = styled.div<{ loading: boolean }>`
  display: ${({ loading }) => (loading ? 'block' : 'none')};
  margin-top: 8px;
  font-size: 12px;
  line-height: 20px;
  color: rgba(39, 38, 77, 0.65);
`;
