import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../../documentModel';
import { useSphereState } from '@tingwu/sphere';
import { useEffect } from 'react';
import { useDataHooks } from '../../../../businessCommon/separateHooks/dataShare';

const useInitPPT = (initFlag?: boolean) => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const { presentationSummaryController } = useDataHooks();
  const { pptTitleInfos, pptSummaryInfos, pptTitleInfosStatus } =
    currentDocBigModelData || {};

  const { docTranslateData } = docTranslateHooks.useDocTranslateData();
  const { bigModelTranslate, translateIsOpen, translateBigModelTargetLoading } =
    docTranslateData || {};
  const { pptTitle, pptSummary, titleGenerator } = bigModelTranslate || {};

  // PPT-标题（议程）数据
  useEffect(() => {
    if (!initFlag) return;
    if (!pptTitleInfos) return;
    const pptAgendaList: any[] = [];
    let titleTras;
    if (
      translateIsOpen &&
      translateBigModelTargetLoading &&
      translateBigModelTargetLoading > 0
    ) {
      titleTras = pptTitle || titleGenerator;
    }

    pptTitleInfos.forEach((item) => {
      const title = translateIsOpen
        ? titleTras?.find((i) => i.id === item.id)?.value || item.title
        : item.title;
      pptAgendaList.push({
        id: item.id,
        beginTime: item.time,
        endTime: item.endTime,
        agendaHeading: title,
      });
    });
    presentationSummaryController.setAgendas(pptAgendaList);
  }, [
    pptTitleInfos,
    pptTitle,
    titleGenerator,
    translateIsOpen,
    translateBigModelTargetLoading,
  ]);

  // PPT-摘要数据
  useEffect(() => {
    if (!initFlag) return;
    if (pptSummaryInfos?.hasPic) {
      const pptList: any = pptSummaryInfos?.contents?.map((item) => {
        const _item: any = { ...item };
        _item.photo = item.pictureKey;
        _item.photoThumbnail = item.pictureThumbnailOssLink;
        if (pptSummary && translateIsOpen) {
          // PPT 摘要翻译
          _item.content =
            pptSummary.find((i) => i.id === _item.index)?.value.split('\n') ||
            _item.content;
        }
        return _item;
      });
      presentationSummaryController.setPPTs(pptList);
    }
  }, [pptSummaryInfos, pptSummary, translateIsOpen]);

  // TODO PPT data
  const pptAgendas =
    useSphereState(presentationSummaryController, 'agendas') || [];
  const pptsMap =
    useSphereState(presentationSummaryController, 'agendaPPTMap') || {};

  const pptlist = useSphereState(presentationSummaryController, 'ppts') || [];

  return {
    pptAgendas,
    pptsMap,
    pptlist,
    modelType: pptSummaryInfos?.modelType,
    pptTitleInfosStatus,
  };
};

export { useInitPPT };
