import styled from 'styled-components';

export const PPTItemContainer = styled.div`
  display: flex;
  position: relative;
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
    color: #27264d;
  }
  .ant-input {
    border: 0px;
    padding: 0px;
    font-size: 12px;
  }
  .pptItem-backtrack {
    position: absolute;
    top: 0;
    left: 0;
  }
  .pptItem-content {
    position: relative;
    width: 100%;
    margin-top: 4px;
    cursor: pointer;
    .pptItem-tips {
      position: absolute;
      top: -52px;
      left: 0px;
      height: 52px;
      width: 128px;
      background-color: var(--Fill_Background_Light);
      box-shadow:
        0 3px 6px -4px rgba(39, 38, 77, 0.12),
        0 6px 16px 0 rgba(39, 38, 77, 0.08),
        0 9px 28px 8px rgba(39, 38, 77, 0.05);
      border-radius: 8px;
      align-items: center;
      cursor: pointer;
      font-weight: 400;
      font-size: 14px;
      color: #27264d;
      padding: 6px 0px;
      display: none;
      z-index: 3;
    }
    :hover {
      /* .pptItem-tips-hover {
        display: flex;
      }

      .pptItem-value-des {
        height: 88px;
        -webkit-line-clamp: 4;
      } */
    }
  }

  .pptItem-value-out-short {
    flex-direction: column;
    padding-right: 16px;
    width: 256px;
    :hover {
      padding-bottom: 32px;
      .pptItem-value-des {
        height: 79px;
      }
    }
    .ant-skeleton-active {
      margin-top: 12px;
    }
    .ant-skeleton-content {
      padding-left: 0px;
    }
  }
  .pptItem-value-out-focus {
    /* min-height: 36px; // 设计稿这么设计的，会导致，聚焦之后，整体上移动 */
    border: 1px solid var(--Text_Primary);
    box-shadow: rgb(96 92 229 / 20%) 0px 0px 0px 2px;
    background-color: var(--Fill_Background_Light);
    white-space: pre-wrap;
    max-height: 60px;
    overflow-y: auto;
    color: #27264d;
    :hover {
      background-color: var(--Fill_Background_Light);
      color: #27264d;
    }
  }
  .pptItem-value-line {
    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 1;
    -webkit-box-orient: vertical;
  }
  .pptItem-value {
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: #27264d;
    -webkit-font-smoothing: antialiased;
  }

  .pptItem-left {
    margin-right: 16px;
    position: relative;
    user-select: none;
    .pptItem-left-time {
      height: 83px;
      display: flex;
      align-items: center;
      position: relative;
      cursor: default;
      user-select: none;
      /* :hover{
      >.pptItem-dot{
        box-shadow: rgb(96 92 229 / 20%) 0px 0px 0px 3px;
       }
    } */
      > .pptItem-time {
        /* width: 46px; */
        width: 68px;
        font-family: PingFangSC, var(--font-family);
        /* font-weight: 500; */
        font-size: 12px;
        color: #27264d;
        letter-spacing: 0;
        user-select: none;
        position: relative;
        .pptItem-time-content {
          position: absolute;
          right: 7px;
          top: -9px;
        }
      }
      > .pptItem-dot {
        height: 8px;
        width: 8px;
        background-color: var(--Text_Secondary);
        border-radius: 8px;
        user-select: none;
      }
      .pptItem-dot-blue {
        background-color: #615ced;
      }
      > .pptItem-left-dashed {
        position: absolute;
        right: 4px;
        top: -4px;
        height: 38px;
        overflow: hidden;
        user-select: none;
      }
    }
    .pptItem-right-dashed {
      display: flex;
      justify-content: flex-end;
      position: absolute;
      right: 4px;
      top: 50px;
      bottom: 0;
      overflow: hidden;
      user-select: none;
    }
  }

  .pptItem-photo-content-others {
    margin-right: 7px;
  }
`;
export const PPTItemContentContainer = styled.div<{
  editStatus?: boolean;
  error?: boolean;
  focus?: boolean;
}>`
  min-height: 40px;
  width: 100%;

  background-color: ${({ editStatus }) =>
    editStatus ? 'var(--Fill_Background_Light)' : 'var(--Fill_Tertiary)'};
  border-radius: 4px;
  padding-left: 12px;
  padding-top: 12px;
  padding-bottom: 12px;
  padding-right: 24px;
  /* border: ${(props) => {
    if (!props.editStatus) return '1px solid transparent';
    if (props.focus) {
      return '0.5px solid var(--Line_Heavy)';
    }
    return props.error
      ? '0.5px solid var(--Danger_Clicked)'
      : '0.5px solid var(--Line_Light)';
  }}; */
  position: relative;
  display: flex;
  /* user-select: none; */
  ${({ editStatus }) => (editStatus ? 'cursor: default;' : 'cursor: pointe;')}
  :hover {
    background-color: var(--Fill_Brand_Tertiary);
    ${(props) =>
      props.editStatus
        ? `
          border-color: var(--Line_Heavy);
        `
        : `
    color: var(--Text_Primary);
    border-color: var(--Line_Heavy);
    .pptItem-value {
      margin-right: 53px;
    }
    .pptItem-review {
      display: flex;
    }`};
  }
  .ant-skeleton-content {
    padding-left: 11px;
  }
  .pptItem-value-photo {
    width: 196px;
    height: 110px;
    .pptItem-value-photo-img-content {
      background-color: var(--Fill_Background_Light);
      border: 1px solid var(--Fill_Background_Light);
      border-radius: 6px;
      width: 196px;
      height: 110px;
    }
  }
  .pptItem-value-photo-out {
    border: 1px solid var(--Line_Light);
    border-radius: 4px;
    overflow: hidden;
  }
  .pptItem-value-photo-short {
    width: 161px;
    height: 90px;
  }
  .pptItem-value-des {
    position: relative;
    line-height: 22px;
    font-size: 12px;
    color: var(--Text_Secondary);

    padding-left: 12px;
    height: 110px;

    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 5;
    -webkit-box-orient: vertical;
  }
  .pptItem-value-des-short {
    padding-left: 0px;
    padding-top: 15px;
    padding-bottom: 15px;
    line-height: 20px;
    height: 99px;
    -webkit-line-clamp: 4;
  }
  .pptItem-value-des-empty {
    color: rgba(39, 38, 77, 0.25);
  }
  .pptItem-value-placeholder {
    position: absolute;
    font-weight: 400;
    font-size: 14px;
    color: rgba(39, 38, 77, 0.45);
    z-index: 1;
  }
  .pptItem-review {
    position: absolute;
    right: 24px;
    top: 12px;
    display: none;
  }
`;
export const PPTPhotoContainer = styled.div<{ editStatus?: boolean }>`
  position: relative;
  width: 196px;
  height: 110px;
  ${({ editStatus }) => (editStatus ? 'cursor: default;' : 'cursor: zoom-in;')};
  .pptItem-photo-content-hover {
    position: absolute;
    width: 100%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    opacity: 0;
    z-index: 20;
    :hover {
      box-shadow:
        0 7px 12px 0 rgba(122, 92, 204, 0.04),
        0 9px 25px 0 rgba(122, 92, 204, 0.05);
      opacity: 1;
    }
  }
  .pptItem-photo-content-hover-others {
    width: calc(100% + 7px);
    cursor: zoom-in;
  }
`;
