import { Presentation, PresentationAgenda } from '@tingwu/sphere';
import { useEffect } from 'react';
import PPTSummaryAdenda from './PPTSummaryAdenda';
import PPTSummaryCardItem from './PPTSummaryCardItem';

const PPTSummaryCardList = ({
  pptList,
  titleInfo,
  index,
  preValue,
  shortMode,
  isAgendaNull,
  transId,
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  scrollIntoViewPPTRef,
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  pptListLength,
  isOverOneHour,
}: {
  pptList: Presentation[];
  titleInfo?: PresentationAgenda;
  preValue?: boolean;
  index: number;
  shortMode?: boolean;
  isAgendaNull?: boolean;
  transId: string;
  scrollIntoViewPPTRef?: { current: any };
  pptListLength: number;
  isOverOneHour: boolean;
}) => {
  let timer: any;
  useEffect(() => {
    if (!scrollIntoViewPPTRef) return;
    if (scrollIntoViewPPTRef.current < 0) return;
    const divs: any = document.getElementsByClassName('tingwu2_ppt_item');

    if (!divs?.length) return;
    Array.from(divs).forEach((element: any) => {
      const { time, custom } = element.dataset;
      if (
        scrollIntoViewPPTRef?.current !== undefined &&
        `${scrollIntoViewPPTRef?.current}` === `${time}` &&
        custom
      ) {
        scrollIntoViewPPTRef.current = -1;
        const { top: tops } = element.getBoundingClientRect();
        const doc = document.getElementById('tingwu_wulab_scrollContainer');
        const topDiv = document.getElementById('tingwu2-bigmodel-top');
        if (!doc || !topDiv) return;
        const { top } = topDiv?.getBoundingClientRect();
        timer && clearTimeout(timer);
        timer = setTimeout(() => {
          console.log('tops - top - 38', tops - top - 38);
          doc.scrollTo({ top: tops - top - 38 });
        }, 500);
      }
    });
  }, [scrollIntoViewPPTRef, scrollIntoViewPPTRef?.current, pptListLength]);

  return (
    <div>
      {titleInfo ? (
        <PPTSummaryAdenda
          info={titleInfo}
          index={index}
          preValue={preValue}
          transId={transId}
          type="simple"
          isOverOneHour={isOverOneHour}
        />
      ) : null}

      {pptList && pptList.length > 0 ? (
        <PPTSummaryCardItem
          info={pptList}
          shortMode={shortMode}
          isAgendaNull={isAgendaNull}
          titleInfo={titleInfo}
          isOverOneHour={isOverOneHour}
        />
      ) : null}
    </div>
  );
};

export default PPTSummaryCardList;
