import { pptReViewInfoStatus } from '../../../../../../recoils/docFile/reviewContent';
import { getFlexibleTime } from '@tingwu/common';
import { Presentation, PresentationAgenda } from '@tingwu/sphere';
import { Fragment, useCallback, useMemo } from 'react';
import { useSetRecoilState } from 'recoil';
import styled from 'styled-components';
import { useReview } from '../hooks/useReview.hook';

const dotBase64 =
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAH1CAYAAAA3YZQyAAAAAXNSR0IArs4c6QAAAFNJREFUSEtjCI8udWNAAHRuZHEPsuwoFxIa4eGlygzhUUWZo9zR0KBfYgDlVUQOBbNGudDiazQ0aJUYQMUcOI1Dir5R7mho0CIxjLYtyG5pASsCABjVqYlUkiQVAAAAAElFTkSuQmCC';

const PPTCardItemContainer = styled.div`
  display: flex;
  position: relative;
  .pptCardItem-content {
    position: relative;
    width: 100%;
    border-radius: 4px;
  }
  .pptCardItem-left {
    margin-right: 16px;
    position: relative;
    user-select: none;
    .pptCardItem-left-time {
      height: 42px;
      display: flex;
      align-items: center;
      position: relative;
      cursor: default;
      user-select: none;
      > .pptCardItem-time {
        width: 40px;
        font-family: PingFangSC, var(--font-family);
        /* font-weight: 500; */
        font-size: 12px;
        color: #27264d;
        letter-spacing: 0;
        user-select: none;
      }
      > .pptCardItem-dot {
        height: 7px;
        width: 7px;
        background-color: #615ced;
        border-radius: 7px;
        user-select: none;
        opacity: 0;
      }
      > .pptCardItem-left-dashed {
        position: absolute;
        right: -3px;
        top: 0;
        height: 11px;
        overflow: hidden;
        user-select: none;
      }
    }
    .pptCardItem-right-dashed {
      display: flex;
      justify-content: flex-end;
      position: absolute;
      right: -3px;
      top: 12px;
      bottom: 0;
      overflow: hidden;
      user-select: none;
      flex-direction: column;
    }
  }
`;
const PPTCardItemContentContainer = styled.div<{ editStatus?: boolean }>`
  min-height: 40px;
  width: 100%;
  position: relative;
  display: flex;
  flex-wrap: wrap;
  padding-right: 12px;
  padding-top: 8px;
  border-radius: 4px;
  background-color: ${({ editStatus }) =>
    editStatus ? '#fff' : 'var(--Fill_Brand_Background)'};
  border: ${(props) => {
    if (props.editStatus) return '0.5px solid rgba(223, 223, 229, 0.6)';
    return '';
  }};
  ${({ editStatus }) => (editStatus ? 'border-radius: 4px;' : '')}
`;
const PPTSummaryCardItem = ({
  // index,
  lastIndex,
  info,
  shortMode,
  isAgendaNull,
  titleInfo,
  isOverOneHour,
}: {
  info: Presentation[];
  titleInfo?: PresentationAgenda;
  // index: number;
  lastIndex?: boolean;
  shortMode?: boolean;
  isAgendaNull?: boolean;
  isOverOneHour: boolean;
}) => {
  const imgs = useMemo(() => {
    if (isAgendaNull) {
      return null;
    }
    if ((info.length > 10 && !shortMode) || (info.length < 11 && shortMode)) {
      return (
        <Fragment>
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
        </Fragment>
      );
    }
    if (info.length > 10 && shortMode) {
      return (
        <Fragment>
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
          <img
            src={dotBase64}
            style={{ display: 'inline-block', width: 1, height: 803 }}
            alt="虚线分割"
          />
        </Fragment>
      );
    }
    return (
      <Fragment>
        <img
          src={dotBase64}
          style={{ display: 'inline-block', width: 1, height: 803 }}
          alt="虚线分割"
        />
      </Fragment>
    );
  }, [info, shortMode, isAgendaNull]);

  return (
    <PPTCardItemContainer>
      {!isAgendaNull ? (
        <div className="pptCardItem-left">
          <div className="pptCardItem-left-time">
            <div
              className="pptCardItem-time"
              style={{ width: isOverOneHour ? '62px' : '40px' }}
            />
            <div className="pptCardItem-left-dashed">
              <img
                src={dotBase64}
                style={{ display: 'inline-block', width: 1, height: 803 }}
                alt="虚线分割"
              />
            </div>
            <div className="pptCardItem-dot" />
          </div>
          {!lastIndex ? (
            <div className="pptCardItem-right-dashed">{imgs}</div>
          ) : null}
        </div>
      ) : null}
      <div style={{ display: 'block' }} className="pptCardItem-content">
        <PPTCardItemContentContainer>
          {info.map((ppt) => {
            return (
              <PPTCard
                key={ppt.beginTime}
                pptInfo={ppt}
                titleInfo={titleInfo}
              />
            );
          })}
        </PPTCardItemContentContainer>
      </div>
    </PPTCardItemContainer>
  );
};

export default PPTSummaryCardItem;

const PPTCardContainer = styled.div<{ editStatus?: boolean }>`
  width: 182px;
  margin-left: 12px;
  margin-bottom: 16px;
  position: relative;
  .pptCard-time {
    font-size: 12px;
    color: var(--Text_Caption);
    letter-spacing: 0;
    height: 24px;
    line-height: 24px;
    position: relative;
    cursor: pointer;
  }
  .pptCard-time-review {
    position: absolute;
    right: 0;
    top: 0;
    display: none;
  }
  :hover {
    .pptCard-time-review {
      display: block;
    }
  }
  .pptCard-photo {
    width: 182px;
    height: 102px;
    background-color: #d8d8d8;
    border: 1px solid rgba(39, 38, 77, 0.05);
    border-radius: 4px;
    box-sizing: border-box;
    background-position: center;
    background-repeat: no-repeat;
    background-size: contain;
    background-color: #e0e2f0;
    overflow: hidden;
  }
  .pptCard-photo-content {
    position: relative;
    width: 182px;
    height: 102px;
    .pptCard-photo-content-hover {
      position: absolute;
      width: 100%;
      height: 40px;
      bottom: 0;
      display: none;
      justify-content: space-between;
      padding-left: 8px;
      padding-right: 8px;
      padding-bottom: 8px;
      background: linear-gradient(180deg, rgba(0, 0, 0, 0) 7%, #000000 98%);

      .pptCard-left {
        display: flex;
        align-items: end;
        cursor: zoom-in;
      }
      .pptCard-right {
        display: flex;
        align-items: end;
      }
    }
    :hover {
      ${({ editStatus }) =>
        editStatus
          ? ''
          : `.pptCard-photo-content-hover {
        display: flex;
      }`}
    }
  }
`;

const PPTCard = ({
  pptInfo,
}: {
  pptInfo: Presentation;
  titleInfo?: PresentationAgenda;
}) => {
  const { onPPTReviewHandler } = useReview();
  const onReviewHandler = useCallback(
    (e) => {
      e.stopPropagation();
      onPPTReviewHandler(pptInfo);
    },
    [onPPTReviewHandler, pptInfo],
  );
  const setPptReViewInfo = useSetRecoilState(pptReViewInfoStatus);
  const onPhotoViewer = (e) => {
    e.stopPropagation();
    setPptReViewInfo(pptInfo);
  };

  return (
    <PPTCardContainer
      className="tingwu2_ppt_item"
      data-time={(pptInfo as any).beginTime}
      data-custom={(pptInfo as any).index === 0}
    >
      <div className="pptCard-time" onClick={onReviewHandler}>
        {getFlexibleTime(pptInfo.beginTime)}
      </div>
      <div
        className="pptCard-photo-content"
        style={{ cursor: 'zoom-in' }}
        onClick={onPhotoViewer}
      >
        <div className="pptCard-photo">
          <img
            src={(pptInfo as any)?.pictureKey}
            style={{
              width: 182,
              height: 102,
              objectFit: 'contain',
            }}
          />
        </div>
      </div>
    </PPTCardContainer>
  );
};
