import useResizeAware from '../../../../../../../hooks/useResizeAware';
import { Tooltip } from '@tingwu/design';
import { getFlexibleTime } from '@tingwu/common';
import React from 'react';
import { PPTSummaryAdendaProps } from './pptSummaryAdenda';
import { PPTAdengeContainer, PPTLine, PPTTitleContainer } from './style';

const dotBase64 =
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAH1CAYAAAA3YZQyAAAAAXNSR0IArs4c6QAAAFNJREFUSEtjCI8udWNAAHRuZHEPsuwoFxIa4eGlygzhUUWZo9zR0KBfYgDlVUQOBbNGudDiazQ0aJUYQMUcOI1Dir5R7mho0CIxjLYtyG5pASsCABjVqYlUkiQVAAAAAElFTkSuQmCC';
/**
 * PPT 标题
 * @param param0
 * @returns
 */
const PPTSummaryItemAdenge = ({
  index = 1,
  lastIndex,
  info,
  preValue,
  type,
  isOverOneHour,
}: PPTSummaryAdendaProps) => {
  const [zIndex, setZIndex] = React.useState(-1);
  const ref: any = React.useRef();
  const [resizeListener, sizes]: any = useResizeAware();

  React.useEffect(() => {
    if (ref.current) {
      setTimeout(() => {
        if (ref.current?.scrollHeight > ref.current?.clientHeight) {
          setZIndex(1000);
        } else {
          setZIndex(-1);
        }
      }, 0);
    }
  }, [ref, ref.current, sizes]);
  return (
    <div>
      {index !== 0 && info.agendaHeading && preValue ? (
        <PPTLine>
          <div className="pptAdenge-dashed">
            <img
              src={dotBase64}
              style={{ display: 'inline-block', width: 1, height: 803 }}
              alt="虚线分割"
            />
          </div>
        </PPTLine>
      ) : null}

      <PPTAdengeContainer type={type} key={info.beginTime}>
        <div className="pptAdenge-left">
          <div
            className="pptAdenge-left-time"
            style={info.agendaHeading ? {} : { height: 24 }}
          >
            {info.beginTime !== undefined ? (
              <div
                className="pptAdenge-time"
                style={{ width: isOverOneHour ? '68px' : '46px' }}
              >
                <div className="pptAdenge-time-content">
                  {getFlexibleTime(info.beginTime)}
                </div>
              </div>
            ) : (
              <div
                className="pptAdenge-time"
                style={{ width: isOverOneHour ? '68px' : '46px' }}
              />
            )}
            {index !== 0 ? (
              <div className="pptAdenge-left-dashed">
                <img
                  src={dotBase64}
                  style={{ display: 'inline-block', width: 1, height: 803 }}
                  alt="虚线分割"
                />
              </div>
            ) : null}
            <div className="pptAdenge-dot" />
          </div>
          {!lastIndex ? (
            <div className="pptAdenge-right-dashed">
              <img
                src={dotBase64}
                style={{ display: 'inline-block', width: 1, height: 803 }}
                alt="虚线分割"
              />
            </div>
          ) : null}
        </div>
        <div className="pptAdenge-right">
          <PPTTitleContainer type={type}>
            <Tooltip
              title={info.agendaHeading}
              zIndex={zIndex}
              placement="right"
              overlayInnerStyle={{ maxWidth: 320 }}
            >
              <div className={`pptAdenge-value-out`}>
                <div className="pptAdenge-value-des">
                  <span
                    className={`pptSmallItem-value-des-value pptSmallItem-value-des-value-two-line`}
                    ref={ref}
                  >
                    {resizeListener}
                    {info.agendaHeading}
                  </span>
                </div>
              </div>
            </Tooltip>
          </PPTTitleContainer>
        </div>
      </PPTAdengeContainer>
    </div>
  );
};

export default PPTSummaryItemAdenge;
