import { eDocScene } from '../../../../../../../documentModel';
import { FileModel } from '../../../../../../../pages/docASR/utils/config';
import styled, { css } from 'styled-components';

export const Wrapper = styled.div<{ isOnly?: boolean }>`
  display: flex;
  align-items: center;
  position: relative;
  ${({ isOnly }) =>
    !isOnly
      ? ` ::after {
    content: ' ';
    display: block;
    position: absolute;
    bottom: 0px;
    left: 0px;
    right: 0px;
    height: 1px;
    border-radius: 2px;
    // background-color: rgba(39, 38, 77, 0.08);
  }`
      : ''}
`;

export const TabItem = styled.div<{
  shortMode?: boolean;
}>`
  padding: ${(props) => (props.shortMode ? '0 8px' : '0 12px')};
  position: relative;

  /* &:after {
    content: ' ';
    display: block;
    position: absolute;
    background-color: #cdcdd6;
    width: 1px;
    height: 14px;
    bottom: 8px;
    right: 0;
  } */

  &:first-child {
    padding-left: 0;
  }

  &:last-child {
    padding-right: 0;
    &:after {
      display: none;
    }
  }
`;

export const TabItemDot = styled.div`
  position: absolute;
  right: -10px;
  top: 6px;
  width: 9px;
  height: 9px;
  border-radius: 9px;
  border: 1px solid rgb(255, 255, 255);
  background-color: var(Text-Danger);
`;
export const TabItemInner = styled.div<{
  active: boolean;
  only: boolean;
  model?: eDocScene;
}>`
  position: relative;
  padding: 3px 0;
  display: flex;
  align-items: center;
  cursor: pointer;
  font-size: 13px;
  line-height: 24px;
  color: var(--Text_Primary);
  transition: all 0.2s;

  .tingwu-icon {
    transition: all 0.2s;
    color: #cdcdd6;
    margin-right: 8px;
  }

  &:after {
    content: ' ';
    display: block;
    position: absolute;
    bottom: 0;
    left: 20px;
    right: 20px;
    height: 2px;
    border-radius: 2px;
    background-color: var(--Fill_Brand_Primary);
    transition: all 0.2s;
    opacity: 0;
  }

  ${(props) =>
    props.active &&
    css`
      color: var(--Text_Primary);
      font-weight: 600;
      .tingwu-icon {
        color: var(--Text_Primary);
      }
    `}
  ${(props) =>
    props.active &&
    !props.only &&
    css`
      &:after {
        opacity: 1;
        left: 0;
        right: 0;
      }
    `}
`;
