import {
  docBigModelHooks,
  documentHooks,
} from '../../../../../../documentModel';
import { SummaryAnimation } from '@tingwu/sphere';
import React, { useMemo, useRef } from 'react';
import { useDataHooks } from '../../../businessCommon/separateHooks/dataShare';
import FileCardHeader from '../../common/FileCardHeader';
import DirtyMeetingSummaryCardToYQ from '../DirtyMeetingSummaryCardToYQ';

const DirtyMeetingSummaryCard = () => {
  const {
    documentData: { docId: transId, docScene },
  } = documentHooks.useDocumentData();
  const { meetingSummaryController } = useDataHooks();
  // 全文概要原文数据
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const { fullTextSummary } = currentDocBigModelData || {};

  const dirtyMeetingSummaryCardToYQRef = useRef<any>();

  // 全文概要显示翻译
  React.useEffect(() => {
    meetingSummaryController.setState('content', fullTextSummary?.value || '');
  }, [fullTextSummary]);

  const supportModifySummaryCard = useMemo(() => {
    return (
      <SummaryAnimation>
        <div style={{ marginBottom: 28 }} className="keyWord">
          <FileCardHeader
            titleText=""
            titleIconType=""
            style={{ lineHeight: '26px' }}
          />
          <DirtyMeetingSummaryCardToYQ ref={dirtyMeetingSummaryCardToYQRef} />
        </div>
      </SummaryAnimation>
    );
  }, [docScene, transId]);
  return supportModifySummaryCard;
};

export default DirtyMeetingSummaryCard;
