import { memo, useMemo, useRef } from 'react';

import { SummaryAnimation } from '@tingwu/sphere';

/** 组件 */
import FileCardHeader from '../../common/FileCardHeader';
import Keyword from '../Keyword';

/** 接口 hooks */
import {
  docBaseHooks,
  docBigModelHooks,
  docTranslateHooks,
  documentHooks,
} from '../../../../../../documentModel';

/** 公共的数据/工具 */
import { eLabInfoStatus } from '../../../../../../documentModel/docBigModel';
import { tabsLangs } from '../../../../../../pages/docASR/utils/config';

const BusKeyWord = memo(() => {
  const {
    documentData: { docId: transId, docScene },
  } = documentHooks.useDocumentData();

  const { docBaseData: { tag: { lang = '' } = {} } = {} } =
    docBaseHooks.useDocBaseData(); // 当前语言

  const {
    currentDocBigModelData: {
      keyWordInfo: keywordInfo, // 关键词【源语言】数据
      keyWordInfoStatus, // 关键词【源语言】数据状态
    } = {},
  } = docBigModelHooks.useDocBigModelData();
  const {
    docTranslateData: {
      translateIsOpen: transSwitch, // 翻译是否开启
    } = {},
  } = docTranslateHooks.useDocTranslateData();

  const keywordRef = useRef<any>(); // 关键词控件

  /** 关键词区域是否展示 */
  /** 非内容盒子 & 符合语言条件 & 数据加载完毕 */
  const busKeyWordVisible = useMemo(() => {
    return (
      lang &&
      tabsLangs.KeyWord.includes(lang) &&
      keyWordInfoStatus === eLabInfoStatus.FINISH
    );
  }, [docScene, keyWordInfoStatus, lang]);

  /** 卡片通用头部 */
  const renderFileCardHeader = useMemo(() => {
    const busKeyWordText = '关键词';
    return (
      <FileCardHeader
        titleText={busKeyWordText}
        titleIconType=""
        style={
          keywordInfo?.length === 0
            ? { margin: '0px 0 12px 0' }
            : { marginBottom: '0' }
        }
      />
    );
  }, [docScene, keyWordInfoStatus, keywordInfo, transId, transSwitch]);

  /**  关键词展示 */
  const renderKeyword = useMemo(() => {
    return <Keyword ref={keywordRef} />;
  }, []);

  return (
    <>
      {busKeyWordVisible ? (
        <SummaryAnimation>
          <div style={{ marginBottom: 24, marginTop: 14 }} className="keyWord">
            {/* 卡片通用头部 */}
            {renderFileCardHeader}
            {/* 关键词展示 */}
            {renderKeyword}
          </div>
        </SummaryAnimation>
      ) : null}
    </>
  );
});

export default BusKeyWord;
