import styled from 'styled-components';

export const FileWulabContainer = styled.div`
  height: 100%;
  overflow: overlay;
  padding: 0 22.5px 0 30.5px;
  position: relative;
  .ant-affix {
    z-index: 100;
  }
`;

export const QuickLook = styled.div`
  margin-bottom: 20px;
  margin-top: 4px;
  display: flex;
  align-items: center;
  color: var(--Text_Disabled);
  .helpIcon {
    margin-left: 2px;
    cursor: pointer;
    &:hover {
      svg {
        fill: var(--Text_Disabled);
      }
    }
  }
`;

export const MessageLineContainer = styled.div`
  text-shadow: 0 1px 0 #fff;
  > div > div:nth-child(odd) {
    box-shadow: 0 1px 0 #fff;
  }
`;
export const ToTopButton = styled.div<{
  bottom: number;
}>`
  position: fixed;
  background-color: var(--Fill_Background_Light);
  right: 31px;
  bottom: ${(props) => props.bottom}px;
  cursor: pointer;
  box-shadow: 0px 4px 6px 0px rgba(0, 0, 0, 0.08);
  border-radius: 6px;
  font-size: 20px;
  line-height: 22px;
  height: 32px;
  width: 32px;
  display: flex;
  color: var(--Text_Secondary);
  justify-content: center;
  align-items: center;
  z-index: 301;
  border: 1px solid var(--Line_Secondary);
  /* :hover {
    background-color: rgba(39, 38, 77, 0.4);
  } */
`;
