import styled, { createGlobalStyle, keyframes } from 'styled-components';

const gradientColor = keyframes`
  0% {
    opacity: 1;
  }
  50% {
    opacity: 0;
  }
  100% {
    opacity: 1;
  }
`;

const show = keyframes`
  0% {
    margin-top: -40px;
    margin-bottom: 0;
    opacity: 0;
  }
  100% {
    margin-top: 0;
    margin-bottom: 16px;
    opacity: 1;
  }
`;

const hide = keyframes`
  0% {
    margin-top: 0;
    margin-bottom: 16px;
    opacity: 1;
  }
  100% {
    margin-top: -40px;
    margin-bottom: 0;
    opacity: 0;
  }
`;

const textShow = keyframes`
  0% {
    transform: translateY(-50%);
    opacity: 0;
  }
  30% {
    transform: translateY(0);
    opacity: 1;
  }
  100% {
    transform: translateY(0);
    opacity: 1;
  }
`;

const textHide = keyframes`
  0% {
    transform: translateY(0);
    opacity: 1;
  }
  100% {
    transform: translateY(50%);
    opacity: 0;
  }
`;

export const Container = styled.div`
  position: relative;
  height: 40px;
  display: none;
  justify-content: center;
  align-items: center;
  margin-bottom: 16px;
  margin-top: 12px;
  .contentDiv {
    height: 24px;
    min-width: 137px;
    display: flex;
    align-items: center;
    font-size: 12px;
    color: var(--Text_Secondary);
    letter-spacing: 0;
    line-height: 24px;

    .loading-content {
      display: flex;
      justify-content: center;
      align-items: center;
      visibility: hidden;
      z-index: 10;
    }
    .tingwu-icon {
      margin-top: -1px;
      margin-right: 8px;
    }
  }

  /* 内容文字切换动画 */
  .animation-loading-text-show {
    animation: ${textShow} 2s;
  }
  .animation-loading-text-hide {
    animation: ${textHide} 0.3s;
  }
`;

/* 渐变色动画 */
export const AnimationColor = styled.div`
  position: absolute;
  width: 100%;
  height: 100%;
  border-radius: 4px;
  background-image: linear-gradient(
    270deg,
    #d7d9df 0%,
    #eaecef 50%,
    #d7d9df 100%
  );
  animation: ${gradientColor} 2s infinite linear alternate;
`;

export const BackgroundColor = styled.div`
  position: absolute;
  width: 100%;
  height: 100%;
  background: var(--Fill_Brand_Tertiary);
  border-radius: 4px;
`;

export const GlobalStyle: any = createGlobalStyle`
  /* loading呼吸动画 */
  .intelligence-loading-show {
    animation: ${show} 0.3s;
  }
  .intelligence-loading-hide {
    animation: ${hide} 0.3s;
  }
`;
