import styled from 'styled-components';

export const TitleWrapper = styled.div`
  .is-pinned {
    background: #f4f7fc;
  }
  .sphereCard-headingOperates {
    visibility: hidden;
  }
  &:hover .sphereCard-headingOperates {
    visibility: visible;
  }
`;
export const TitleHeading = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  background-color: var(--Fill_Background_Light);
  position: relative;
  padding-bottom: 12px;
  position: sticky;
  padding-top: 0px;
  top: -1px;
  z-index: 10;
`;
export const Title = styled.div`
  font-size: 14px;
  color: var(--Text_Primary);
  height: 26px;
  line-height: 24px;
  -webkit-font-smoothing: antialiased;
  /* font-weight: 600; */
  cursor: default;
  display: flex;
  align-items: center;
  user-select: none;

  & > .tingwu-icon {
    color: #615ced;
    margin-right: 8px;
  }
`;
export const HeadingExtraContainer = styled.div`
  display: flex;
  align-items: center;
`;
export const HeadingOperates = styled.span`
  display: inline-flex;
  align-items: center;
  gap: 14px;

  .icon-item {
    font-size: 18px;
    color: var(--Text_Primary);
    :hover {
      color: var(--Text_Primary);
    }
  }
`;
export const MeetingBigModelWrapper = styled.div`
  padding: 12px 32px;
  height: 100%;
  overflow: overlay;
`;
