import { Tabs } from '../../../../../../pages/docASR/utils/config';

interface iFeedbackConfig {
  [key: string]: {
    title: string;
    list: string[];
  };
}

const feedbackConfig: iFeedbackConfig = {
  [`${Tabs.Agenda}`]: {
    title: '你觉得章节速览准确吗？',
    list: [
      '内容与原文不相关',
      '内容总结不全面',
      '表达不流畅',
      '存在事实性错误',
    ],
  },
  [`${Tabs.SpeakerSummary}`]: {
    title: '你觉得发言总结准确吗？',
    list: [
      '内容与原文不相关',
      '内容总结不全面',
      '表达不流畅',
      '存在事实性错误',
    ],
  },
  [`${Tabs.PPT}`]: {
    title: '你觉得提取PPT准确吗？',
    list: [
      '提取结果有遗漏',
      '提取结果重复',
      '提取结果存在错误',
      '文字总结不准确',
    ],
  },
  // ----
  [`${Tabs.Highlights}`]: {
    title: '你觉得要点回顾准确吗？',
    list: ['要点回顾不准确', '内容与原文无关', '要点回顾多了', '要点回顾少了'],
  },
  [`${Tabs.QNAReview}`]: {
    title: '你觉得问答回顾准确吗？',
    list: ['问答回顾不准确', '内容与原文无关', '问答回顾多了', '问答回顾少了'],
  },
  [`${Tabs.ToDoList}`]: {
    title: '你觉得待办事项准确吗？',
    list: [
      '待办事项识别少了',
      '待办事项识别多了',
      '待办提炼不准确',
      '内容与原文无关',
    ],
  },
};
export { feedbackConfig };
