import React from 'react';
import { HeadingTabs } from '../../../Fragmented/HeadingTabs';
// *** 样式文件相关 ***
import { HeadingTabsContainer } from '../../../Agenda/styled';
// *** 类型定义文件 ***
import type { iTitleTabs } from './TitleTabs.type';

const TitleTabs: React.FC<iTitleTabs> = (props) => {
  const {
    // lang,
    tabs,
    tabRef,
    shortMode,
    currentTab,
    onClickTab,
    pptDotVisible,
    isOnly,
  } = props;

  return (
    <HeadingTabsContainer ref={tabRef}>
      <HeadingTabs
        isOnly={isOnly}
        shortMode={shortMode}
        tabs={tabs}
        value={currentTab}
        onClickTab={onClickTab}
        dotVisible={pptDotVisible}
      />
    </HeadingTabsContainer>
  );
};

const memoWrapper = React.memo(TitleTabs);

export { memoWrapper as TitleTabs };
