import React from 'react';
// *** 三方包相关 ***
import { Tooltip, TYIcon } from '@tingwu/design';
// *** 二方包相关 ***
// *** 类型定义文件 ***
import type { iEditButton } from './EditButton.type';

const EditButton: React.FC<iEditButton> = ({ onEdit }) => {
  return (
    <Tooltip title="编辑" overlayClassName="tingwu2-tips">
      <TYIcon
        data-e2e-test-id="keyword_edit_icon"
        className="icon-item"
        type={'tongyi-edit-line'}
        size={13}
        style={{ margin: '0px 0px 0px 2px' }}
        onClick={onEdit}
      />
    </Tooltip>
  );
};

const memoWrapper = React.memo(EditButton);

export { memoWrapper as EditButton };
