import { AvatarForSpeaker } from '../../../../../../../components/BaseCompontents/AvatarForSpeaker';
import { docSpeakerHooks } from '../../../../../../../documentModel';
import { iDocSpeaker } from '../../../../../../../documentModel/docSpeaker/docSpeaker.type';
import { useCallback, useEffect, useState } from 'react';

/**
 * 发言人信息获取
 */
const useSpeaker = (avatarSize = 19) => {
  // const { docSpeakerData, speakersSplitIsOpen, speakersSplitIsLoading } =
  const { docSpeakerData, getSpeakerDataFromUid } =
    docSpeakerHooks.useDocSpeakerData();
  const { speakersData, speakersSplitIsLoading } = docSpeakerData || {};
  const [speakers, setSpeakers] = useState<iDocSpeaker[]>([]); // 演讲人集合

  useEffect(() => {
    if (speakersData) {
      setSpeakers(speakersData);
    }
  }, [speakersData]);

  //  获取名字
  const getName = useCallback(
    (uid = '') => {
      const speaker = getSpeakerDataFromUid(uid);
      console.log('speaker', speaker);

      return speaker?.name || speaker?.displayName;
    },
    [getSpeakerDataFromUid],
  );

  //   获取头像
  const getAvatar = useCallback(
    (uid = '') => {
      const item = speakers.find((i) => i.uid === uid);

      if (!item) {
        return null;
      }
      if (speakersSplitIsLoading && item.name === '') {
        return (
          <img
            src="https://img.alicdn.com/imgextra/i2/O1CN01j1zJ601ldECQqGWtH_!!6000000004841-54-tps-24-24.apng"
            // alt="加载中头像"
          />
        );
      }
      return (
        <AvatarForSpeaker
          uid={item.uid}
          displayName={item.displayName}
          speakerAvatar={item.speakerAvatar}
          speakerAvatarName={item.speakerAvatarName}
          inSpeakerSummer={item.inSpeakerSummer}
          ui={item.ui}
          name={item.name}
          avatarSize={avatarSize}
        />
      );
    },
    [avatarSize, speakers, speakersSplitIsLoading],
  );

  // 获取头像和名称列表
  const getAvatarNameList = useCallback(
    (uids: any[] = []) => {
      return uids
        .filter((item) => item)
        .map((uid) => ({
          avatar: getAvatar(uid),
          avatarName: getName(uid),
        }));
    },
    [getAvatar, getName],
  );

  return {
    getAvatar, // 获取头像
    getName, // 获取名称
    getAvatarNameList, // 获取头像和名称列表
  };
};

export { useSpeaker };
