import styled, { keyframes } from 'styled-components';

export const LoadingMessage = styled.div`
  color: rgba(39, 38, 77, 0.7);
`;

export const Mask = styled.div`
  display: flex;
  align-items: center;
  width: 100%;
  bottom: 0;
  background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #f4f7fc 60%);
`;

export const ExpandText = styled.div`
  position: relative;
  font-size: 12px;
  cursor: pointer;
  color: var(--Text_Primary);

  &:hover {
    color: var(--Text_Secondary);
  }
  &:active {
    color: var(--Text_Secondary);
  }

  pointer-events: visible;
`;

export const RedDot = styled.div`
  position: absolute;
  top: 0px;
  right: 3px;
  width: 9px;
  height: 9px;
  border-radius: 9px;
  border: 1px solid var(--Text_Brand_Primary);
  background-color: var(--Danger_Default);
`;

const switchShow = keyframes`
  0% {
    opacity: 0;
    margin-top: -20px;
  }
  100% {
    opacity: 1;
    margin-top: 0;
  }
`;

export const SwitchAnimationContainer = styled.div`
  position: relative;
  animation: ${switchShow} 0.3s;
`;

export const AgendaContainer = styled.div``;
export const WulabContainer = styled.div`
  .tignwu2-PPTcontainer {
    -webkit-backface-visibility: hidden;
    -webkit-transform: translate3d(0, 0, 0);
  }
`;

export const HeadingTabsContainer = styled.div`
  display: flex;
  justify-content: space-between;
  .ppt_icon {
    font-weight: 600;
  }
`;
export const ButtonsContainer = styled.div`
  display: flex;
  justify-content: flex-end;
  align-items: center;
  /* margin-top: 8px; */
  height: 40px;
  position: absolute;
  right: 32px;
  .m_line {
    height: 15px;
    width: 1px;
    margin-left: 16px;
    background-color: rgba(39, 38, 77, 0.12);
    border: 0px solid rgba(39, 38, 77, 0.12);
  }
  .m_confirm {
    color: #615ced;
    height: 20px;
    // width: 24px;
    font-weight: 400;
    font-size: 12px;
    letter-spacing: 0;
    line-height: 20px;
    margin-left: 16px;
    cursor: pointer;
    :hover {
      color: rgb(96, 92, 229, 0.6);
    }
  }
  .m_cancel {
    height: 20px;
    // width: 24px;
    font-weight: 400;
    font-size: 12px;
    color: var(--Text_Disabled);
    letter-spacing: 0;
    line-height: 20px;
    margin-left: 33px;
    cursor: pointer;
    :hover {
      color: var(--Text_Disabled);
    }
  }
  .m_loading {
    color: var(--Text_Disabled);
    cursor: not-allowed;
    :hover {
      color: var(--Text_Disabled);
    }
  }
  .m_loading_cancel {
    color: var(--Text_Secondary);
    :hover {
      color: var(--Text_Secondary);
    }
  }
`;
