import {
  docBigModelHooks,
  docTranslateHooks,
} from '../../../../../../../documentModel';
import { iChapterOverview } from '../../../../../../../documentModel/docBigModel';
import { useEffect, useState } from 'react';

const useInitAgenda = () => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const {
    chapterOverview, // 章节速览
    chapterOverviewStatus: agendaSummaryStatus, // 章节速览状态
    chapterOverviewFeedback,
  } = currentDocBigModelData || {};

  const [agendaList, setAgendaList] = useState<
    iChapterOverview[] | undefined
  >();

  const { docTranslateData } = docTranslateHooks.useDocTranslateData();
  const { bigModelTranslate, translateIsOpen } = docTranslateData || {};
  const { titleGenerator, agendaSummary } = bigModelTranslate || {};

  useEffect(() => {
    if (!chapterOverview) return;
    const _list = chapterOverview.map((item) => {
      const _item = { ...item };
      if (translateIsOpen && titleGenerator && titleGenerator.length > 0) {
        _item.title =
          titleGenerator.find((i) => i.id === item.id)?.value || item.title;
      }
      if (translateIsOpen && agendaSummary && agendaSummary.length > 0) {
        _item.content =
          agendaSummary.find((i) => i.id === item.id)?.value || item.content;
      }
      return _item;
    });
    setAgendaList(_list);
  }, [titleGenerator, agendaSummary, chapterOverview, translateIsOpen]);

  return {
    agendaList,
    chapterOverviewFeedback,
    agendaSummaryStatus,
  };
};

export { useInitAgenda };
