import styled from 'styled-components';

export const AdendaTimeItemContainer = styled.div`
  display: flex;
  position: relative;
  .adendaTimeItem-backtrack {
    position: absolute;
    top: 0;
    left: 0;
  }
  .adendaTimeItem-content {
    position: relative;
    cursor: pointer;
    width: 100%;
    padding-top: 2px;
    .adendaTimeItem-tips {
      position: absolute;
      top: -52px;
      left: 0px;
      height: 52px;
      width: 128px;
      background-color: var(--Fill_Background_Light);
      box-shadow:
        0 3px 6px -4px rgba(39, 38, 77, 0.12),
        0 6px 16px 0 rgba(39, 38, 77, 0.08),
        0 9px 28px 8px rgba(39, 38, 77, 0.05);
      border-radius: 8px;
      align-items: center;
      cursor: pointer;
      font-weight: 400;
      font-size: 14px;
      color: var(--Text_Primary);
      padding: 6px 0px;
      display: none;
      z-index: 3;
    }
    :hover {
      .adendaTimeItem-tips-hover {
        display: flex;
      }
    }
  }
  .adendaTimeItem-value-out {
    min-height: 40px;
    width: 100%;
    background-color: var(--Fill_Tertiary);
    border-radius: 8px;
    padding: 16px;
    position: relative;
    display: flex;
    /* border: 0.5px solid transparent; */
    &:hover {
      /* border: 0.5px solid var(--Line_Heavy); */
      background-color: var(--Fill_Brand_Tertiary);
      .adendaTimeItem-value {
        margin-right: 0px;
        /* font-size: 13px; */
        /* color: var(--Text_Brand_Primary); */
      }
      .adendaTimeItem-review {
        display: flex;
      }
      .adendaTimeItem-value-des {
        /* color: var(--Text_Brand_Primary); */
      }
    }
    .adendaTimeItem-value-des-container {
      overflow: hidden;
      transition: height 0.3s;
    }
    .adendaTimeItem-value-des {
      line-height: 20px;
      margin-top: 4px;
      font-size: 12px;
      color: var(--Text_Secondary);

      transition: opacity 0.3s;
    }
    .adendaTimeItem-value-placeholder {
      position: absolute;
      font-weight: 400;
      font-size: 14px;
      color: rgba(39, 38, 77, 0.45);
      z-index: 1;
    }
    .adendaTimeItem-review {
      position: absolute;
      right: 16px;
      top: 12px;
      display: none;
    }
  }
  .adendaTimeItem-value-out-focus {
    /* min-height: 36px; // 设计稿这么设计的，会导致，聚焦之后，整体上移动 */
    border: 1px solid var(--Line_Heavy);
    box-shadow: 0px 2px 2px 0px;
    background-color: var(--Fill_Background_Light);
    white-space: pre-wrap;
    max-height: 60px;
    overflow-y: auto;
    color: var(--Text_Caption);
    :hover {
      background-color: var(--Fill_Background_Light);
    }
  }
  .adendaTimeItem-value-line {
    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 1;
    -webkit-box-orient: vertical;
  }
  .adendaTimeItem-value-tow-line {
    word-break: break-all;
    text-overflow: -o-ellipsis-lastline;
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
  }
  .adendaTimeItem-value {
    line-height: 24px;
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: var(--Text_Primary);
    cursor: pointer;
    -webkit-font-smoothing: antialiased;
    font-weight: 500;
  }

  .adendaTimeItem-left {
    margin-right: 16px;
    position: relative;
    user-select: none;
    .adendaTimeItem-left-time {
      height: 48px;
      display: flex;
      align-items: center;
      position: relative;
      cursor: default;
      user-select: none;
      padding-top: 14px;
      /* :hover{
      >.adendaTimeItem-div{
        width: 8px;
        padding: 4px 0px;
        background-color: var(--Fill_Background_Light);
        z-index: 1000;
        .adendaTimeItem-dot{
          box-shadow: rgb(96 92 229 / 20%) 0px 0px 0px 3px;
         }
      }
    } */
      > .adendaTimeItem-time {
        width: 83px;
        font-family: PingFangSC, var(--font-family);
        /* font-weight: 500; */
        font-size: 12px;
        color: var(--Text_Primary);
        letter-spacing: 0;
        user-select: none;
        position: relative;
        .adendaTimeItem-time-content {
          position: absolute;
          right: 7px;
          top: -9px;
        }
      }
      > .adendaTimeItem-div {
        width: 8px;
        padding: 4px 0px;
        background-color: var(--Fill_Background_Light);
        z-index: 8;
        > .adendaTimeItem-dot {
          height: 8px;
          width: 8px;
          background-color: var(--Text_Secondary);
          border-radius: 8px;
          user-select: none;
        }
      }
      > .adendaTimeItem-left-dashed {
        position: absolute;
        right: 3px;
        top: 0;
        height: 26px;
        overflow: hidden;
        user-select: none;
      }
    }
    .adendaTimeItem-right-dashed {
      display: flex;
      justify-content: flex-end;
      position: absolute;
      right: 3px;
      top: 33px;
      bottom: 0;
      overflow: hidden;
      user-select: none;
    }
  }
`;
export const AdendaTimeItemInputContent = styled.div<{
  error: boolean;
  focus: boolean;
}>`
  position: relative;
  cursor: pointer;
  width: 100%;
  padding-top: 6px;
  [contenteditable]:focus {
    outline: none;
    font-weight: normal;
  }
  .AdendaTimeItemInput-tips {
    position: absolute;
    top: -52px;
    left: 0px;
    height: 52px;
    width: 128px;
    background-color: var(--Fill_Background_Light);
    box-shadow:
      0 3px 6px -4px rgba(39, 38, 77, 0.12),
      0 6px 16px 0 rgba(39, 38, 77, 0.08),
      0 9px 28px 8px rgba(39, 38, 77, 0.05);
    border-radius: 8px;
    align-items: center;
    cursor: pointer;
    font-weight: 400;
    font-size: 14px;
    color: var(--Text_Caption);
    padding: 6px 0px;
    display: none;
    z-index: 3;
  }
  :hover {
    .AdendaTimeItemInput-tips-hover {
      display: flex;
    }
  }

  .AdendaTimeItemInput-value-out {
    min-height: 40px;
    width: 100%;
    background-color: var(--Fill_Background_Light);
    border-radius: 8px;
    padding-left: 16px;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-right: 16px;
    border: ${(props) => {
      if (props.focus) {
        return '0.5px solid var(--Line_Heavy)';
      }
      return props.error
        ? '0.5px solid var(--Text_Danger)'
        : '0.5px solid var(--Line_Light)';
    }};

    position: relative;
    display: flex;
    flex-direction: column;
    z-index: 2;
    :hover {
      box-shadow: 0 0 0 2px rgba(0, 0, 0, 0.1);
    }
    .AdendaTimeItemInput-value-des-container {
      overflow: hidden;
      transition: height 0.3s;
    }

    .AdendaTimeItemInput-value-placeholder {
      position: absolute;
      font-weight: 400;
      font-size: 14px;
      color: var(--Text_Disabled);
      z-index: 1;
    }
    .AdendaTimeItemInput-review {
      position: absolute;
      right: 16px;
      display: none;
    }
  }
  .AdendaTimeItemInput-value {
    font-size: 14px;
    letter-spacing: 0;
    box-sizing: border-box;
    white-space: pre-wrap;
    overflow-wrap: anywhere;
    position: relative;
    z-index: 2;
    color: var(--Text_Primary);
    cursor: pointer;
    /* user-modify: read-write-plaintext-only; */
    -webkit-user-modify: read-write-plaintext-only;
    -webkit-font-smoothing: antialiased;
  }
  .AdendaTimeItemInput-value-des {
    line-height: 20px;
    margin-top: 4px;
    font-size: 12px;
    color: rgba(39, 38, 77, 0.65);
    position: relative;
    -webkit-user-modify: read-write-plaintext-only;
    z-index: 2;
  }
  .m_input_value {
    position: relative;
  }
  .m_placeholder {
    letter-spacing: 0px;
    color: var(--Text_Disabled);
    position: absolute;
    z-index: 1;
    top: 0;
    line-height: 20px;
  }
`;
