import {
  docBaseHooks,
  docTagHooks,
  documentHooks,
} from '../../../../../../../documentModel';
import { SelectText } from '../../../../../../../pages/docASR/components/atomicComponent/common/SelectText';
import { useDataHooks } from '../../../../../../../pages/docASR/components/businessCommon/separateHooks/dataShare';
import { getFlexibleTime } from '@tingwu/common';
import { Tooltip } from '@tingwu/design';
import React, { useCallback, useMemo, useState } from 'react';
import { AgendaItemProps } from '../types/AgendaItem';
import { AdendaTimeItemContainer } from './style';

const AdendaTimeItemInput = ({
  info,
  index,
  lastIndex,
  alls,
  lang = 'cn',
  count,
  reView,
  isOverOneHour,
}: AgendaItemProps) => {
  const inputRef: any = React.useRef();
  const { controller } = useDataHooks();

  const {
    documentData: { docScene },
  } = documentHooks.useDocumentData() || {};
  const [inputRefIndex, setInputRefIndex] = React.useState(-1);
  const isExpandItem = !alls && count > 2 && index === 2;
  const descDomRef = React.useRef<HTMLDivElement>(null);
  const { docTagData } = docTagHooks.useDocTagData();
  const { audioStatus } = (docTagData || {}) as any;
  const { docBaseData } = docBaseHooks.useDocBaseData();

  React.useEffect(() => {
    const observer = new ResizeObserver(() => {
      if (inputRef.current?.scrollHeight > inputRef.current?.clientHeight) {
        setInputRefIndex(10000);
      } else {
        setInputRefIndex(-20);
      }
    });

    if (inputRef.current) {
      observer.observe(inputRef.current);
    }

    return () => {
      observer.disconnect();
    };
  }, [inputRef, index]);

  const onReviewHandler = useCallback(
    (e: React.MouseEvent<HTMLDivElement, MouseEvent>) => {
      e.stopPropagation();
      if (audioStatus === '0') {
        return;
      }
      reView(info);
    },
    [info, index, reView, audioStatus],
  );

  const timeStyle = useCallback(() => {
    const style: React.CSSProperties = {
      width: isOverOneHour ? 60 : 42,
    };
    if (isOverOneHour) {
      style.textAlign = 'right';
      style.paddingRight = 12;
    }
    return style;
  }, [isOverOneHour])();

  const [agendaSummaryH, setAgendaSummaryH] = useState(0);

  const isTextType = useMemo(() => {
    if (
      ['TEXT_FILE', 'TEXT_FILE_REUSE'].includes(
        docBaseData?.consoleInfo?.taskSourceType,
      )
    )
      return true;
    return false;
  }, [docBaseData?.consoleInfo?.taskSourceType]);

  const right = React.useMemo(() => {
    const content = info.content || info.summary;
    return (
      <SelectText
        style={{
          display: 'block',
          pointerEvents: isTextType ? 'none' : 'auto',
        }}
        className="adendaTimeItem-content"
        onClick={onReviewHandler}
      >
        <Tooltip
          title={info.title}
          zIndex={inputRefIndex}
          open={inputRefIndex > -1}
          placement={
            controller?.getFileModel() === 'bos' ? undefined : 'rightTop'
          } // TODO
          overlayInnerStyle={{ maxWidth: 320 }}
          getPopupContainer={() =>
            document.getElementById('tingwu2_file_container') as any
          }
        >
          <div className={'adendaTimeItem-value-out'}>
            <div style={{ visibility: isExpandItem ? 'hidden' : 'visible' }}>
              <span
                ref={inputRef}
                className={`adendaTimeItem-value${
                  alls
                    ? ' adendaTimeItem-value-tow-line'
                    : ' adendaTimeItem-value-line'
                }`}
              >
                {info.title}
              </span>

              <div
                className={'adendaTimeItem-value-des-container'}
                style={{
                  height: alls && content ? `${agendaSummaryH}px` : '0',
                }}
              >
                <div
                  ref={(div) => {
                    if (div) {
                      setAgendaSummaryH(div.offsetHeight);
                    }
                  }}
                  className="adendaTimeItem-value-des"
                  style={{
                    opacity: alls && content ? '1' : '0',
                  }}
                >
                  {content}
                </div>
              </div>
            </div>
          </div>
        </Tooltip>
      </SelectText>
    );
  }, [
    descDomRef?.current,
    info,
    info.content,
    controller,
    isExpandItem,
    inputRefIndex,
    onReviewHandler,
    agendaSummaryH,
    lang,
    alls,
    docScene,
    isTextType,
  ]);

  if (!info.title) {
    return null;
  }

  return (
    <AdendaTimeItemContainer>
      {!isTextType && (
        <div className="adendaTimeItem-left">
          <div className="adendaTimeItem-left-time">
            {info.time !== undefined ? (
              <div className="adendaTimeItem-time" style={timeStyle}>
                <div className="adendaTimeItem-time-content">
                  {getFlexibleTime(info.time)}
                </div>
              </div>
            ) : (
              <div className="adendaTimeItem-time" />
            )}
            {index !== 0 ? (
              <div className="adendaTimeItem-left-dashed">
                <div
                  style={{
                    display: 'inline-block',
                    width: 1,
                    height: 803,
                    borderRight: '1px dashed var(--Line_Heavy)',
                  }}
                />
              </div>
            ) : null}
            <div className="adendaTimeItem-div">
              <div className="adendaTimeItem-dot" />
            </div>
          </div>
          {!lastIndex ? (
            <div className="adendaTimeItem-right-dashed">
              <div
                style={{
                  display: 'inline-block',
                  width: 1,
                  height: 803,
                  borderRight: '1px dashed var(--Line_Heavy)',
                }}
              />
            </div>
          ) : null}
        </div>
      )}
      {right}
    </AdendaTimeItemContainer>
  );
};

export default AdendaTimeItemInput;
