import { Controller } from '@tingwu/core';
import { iAudioStatus } from '../AudioCore';
import { iMediaAgendaProps, iMediaMarkTokenProps } from '../TWMedia.type';

export interface iDocAudioPlayerProps extends iDocAudioPlayerConfig {
  playerWrapperRef: React.RefObject<HTMLDivElement>; // 外部播放器容器元素
  featureMode: 'trans' | 'share'; // 功能模式
  // 音频播放数据
  audioUrl: string; // 音频播放地址
  audioSegments: number[][]; // 音频分段数据(跳过空白片段用)
  audioSpectrum: number[]; // 音频频谱数据
  // 其他属性控制器
  controller?: Controller; // 听悟控制器
  // 业务数据
  mediaTokens: iMediaMarkTokenProps[];
  mediaAgendas: iMediaAgendaProps[];
  // 事件监听
  onAudioVolumeChange: (volume: number, muted: boolean) => void;
  onAudioRateChange: (rate: number) => void;
  onAudioSkipBlankChange: (skip: boolean) => void;
  onAudioPlayStatusChange: (play: boolean) => void;
  onAudioTimeUpdate: (time: number) => void;
  onAudioSeek: (time: number) => void;
  // eventReporter
  eventReporter: (id: string, params: Record<string, any>) => void; // 事件上报器
}

/** 播放器配置相关 */
export interface iDocAudioPlayerConfig {
  hotKeyEnabled?: boolean; // 快捷键是否启用(默认启用)
}

export type tAudioPlayerState = iAudioStatus & {
  // 1. 基础状态跟随 AudioCore
  audioIsLoading: boolean; // 是否加载中
  audioIsPlaying: boolean; // 音频发播放中
  duration: number; // 音频总时长
  playPercent: number; // 当前播放百分比
  // 2. 业务状态
  skipBlank: boolean; // 是否跳过空白片段
};

export interface iDocAudioPlayerStatus {
  volume?: number;
  muted?: boolean;
  curtTime?: number;
  playbackRate?: number;
  skipBlank?: boolean;
}

export interface iTWDocPlayerHandler {
  audioPlayerToTime: (t: number) => void;
  audioStartPlayOnTime: (t: number) => void;
  syncToAudioPlayer: (s: iDocAudioPlayerStatus) => void;
  audioPlayerPause: () => void;
}
