import { getFlexibleTime } from '@tingwu/common';
import React from 'react';

interface iPlayerTimeProps {
  time: number;
  className?: string;
  extraNode?: React.ReactNode;
}

// 播放器时间
const PlayerTime: React.FC<iPlayerTimeProps> = (props) => {
  let { time } = props;
  if (props.time < 1000) {
    const totalSeconds = Math.round(props.time / 1000);
    time = totalSeconds * 1000;
  }
  return (
    <span className={props.className}>
      {getFlexibleTime(time || 0)}
      {props.extraNode}
    </span>
  );
};

export { PlayerTime };
