import React from 'react';

import { PlayerOpts, VolumeControl } from '../PlayerOpts';
import { PlayerRate } from '../PlayerRate';

import './AudioPlayerOpts.less';

interface iAudioPlayerOptsProps {
  isLoading: boolean;
  volume: number;
  onChangeVolume: (volume: number) => void;
  muted: boolean;
  onChangeMuted: (muted: boolean) => void;
  rate: number;
  onChangeRate: (rate: number) => void;
  isSkipBlank: boolean;
  onChangeSkipBlank: (skipBlank: boolean) => void;
}

// 播放器右侧控制面板
const AudioPlayerOpts: React.FC<iAudioPlayerOptsProps> = (props) => {
  const {
    isLoading,
    rate,
    onChangeRate,
    volume,
    onChangeVolume,
    muted,
    onChangeMuted,
  } = props;

  return (
    <div className="AudioPlayerOpts">
      <PlayerRate
        speed={rate}
        onSpeedChange={onChangeRate}
        isLoading={isLoading}
      />
      <PlayerOpts isLoading={isLoading}>
        {/* <SwitchControl
          title="跳过空白片段"
          checked={isSkipBlank}
          onChange={onChangeSkipBlank}
        /> */}
        <VolumeControl
          volume={volume}
          onVolumeChange={onChangeVolume}
          muted={muted}
          onMuted={onChangeMuted}
        />
      </PlayerOpts>
    </div>
  );
};

export { AudioPlayerOpts };
