import { Tooltip, TYIcon } from '@tingwu/design';
import React, { useCallback } from 'react';

import { isMac } from '../../../../../../../utils/misc';
import './AudioPlayerCtrl.less';

interface iAudioPlayerCtrlProps {
  isLoading: boolean; // 正在加载中
  isPlaying: boolean; // 正在播放
  togglePlay: (play: boolean) => void; // 播放切换
  playBeforeClick: () => void; // 点击上一句
  palyNextClick: () => void; // 点击下一句
}

// 音频播放控制器
const AudioPlayerCtrl: React.FC<iAudioPlayerCtrlProps> = (props) => {
  const { isLoading, isPlaying, togglePlay, playBeforeClick, palyNextClick } =
    props;

  // 点击上一句
  const clickPrev = useCallback(() => {
    if (isLoading) return;

    playBeforeClick();
  }, [isLoading, playBeforeClick]);

  // 播放切换
  const clickToTogglePlay = useCallback(() => {
    if (isLoading) return;

    togglePlay(!isPlaying);
  }, [isLoading, togglePlay, isPlaying]);

  // 点击下一句
  const clickNext = useCallback(() => {
    if (isLoading) return;

    palyNextClick();
  }, [isLoading, palyNextClick]);

  if (isLoading) {
    return (
      <div className="DocAudioPlayer-LeftControlBar">
        <TYIcon
          className={`icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '24px' }}
          type="spark-lastSentence-line"
          onClick={clickPrev}
        />
        <div
          className={`playIcon  ${isLoading && 'docAudioloadingPlays'}`}
          onClick={clickToTogglePlay}
        >
          {!isPlaying ? (
            <TYIcon
              className={`icon ${isLoading ? 'docAudioloading' : ''}`}
              style={{
                fontSize: '32px',
                paddingLeft: '1px',
                color: 'var(--Text_Primary)',
              }}
              type="spark-play-fill"
            />
          ) : (
            <TYIcon
              className={`icon ${isLoading ? 'docAudioloading' : ''}`}
              style={{
                fontSize: '32px',
                color: 'var(--Text_Primary)',
              }}
              type="spark-pause-fill"
            />
          )}
        </div>
        <TYIcon
          className={`icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '24px' }}
          type="spark-nextSentence-line"
          onClick={clickNext}
        />
      </div>
    );
  }

  return (
    <div className="DocAudioPlayer-LeftControlBar">
      <Tooltip
        placement="top"
        overlayInnerStyle={{ display: 'flex', alignItems: 'center' }}
        title={
          <>
            <span className="no-select">
              前一句 {isMac ? 'Command' : 'Ctrl'} +
            </span>
            {/* <PlayIcon style={{ transform: 'rotate(180deg)' }} /> */}
            <TYIcon
              className={`icon ${isLoading && 'docAudioloading'}`}
              style={{
                transform: 'rotate(180deg)',
                fontSize: '18px',
                paddingLeft: '1px',
                color: 'var(--Text_White)',
              }}
              type="icon-play-fill"
            />
          </>
        }
      >
        <TYIcon
          className={`icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '24px' }}
          type="spark-lastSentence-line"
          onClick={clickPrev}
        />
      </Tooltip>

      <Tooltip
        placement="top"
        overlayInnerStyle={{ display: 'flex', alignItems: 'center' }}
        title={`${!isPlaying ? '播放' : '暂停'} ${
          isMac ? 'Option' : 'Shift'
        } + Space`}
      >
        <div
          className={`playIcon  ${isLoading && 'docAudioloadingPlays'}`}
          onClick={clickToTogglePlay}
        >
          {!isPlaying ? (
            <TYIcon
              className={`icon ${isLoading ? 'docAudioloading' : ''}`}
              style={{
                fontSize: '32px',
                paddingLeft: '1px',
                color: 'var(--Text_Primary)',
              }}
              type="spark-play-fill"
            />
          ) : (
            <TYIcon
              className={`icon ${isLoading ? 'docAudioloading' : ''}`}
              style={{
                fontSize: '32px',
                color: 'var(--Text_Primary)',
              }}
              type="spark-pause-fill"
            />
          )}
        </div>
      </Tooltip>

      <Tooltip
        placement="top"
        overlayInnerStyle={{ display: 'flex', alignItems: 'center' }}
        title={
          <>
            <span className="no-select">
              后一句 {isMac ? 'Command' : 'Ctrl'} +
            </span>
            <TYIcon
              className={`icon ${isLoading && 'docAudioloading'}`}
              style={{
                fontSize: '18px',
                paddingLeft: '1px',
                color: 'var(--Text_White)',
              }}
              type="icon-play-fill"
            />
          </>
        }
      >
        <TYIcon
          className={`icon ${isLoading && 'docAudioloading'}`}
          style={{ fontSize: '24px' }}
          type="spark-nextSentence-line"
          onClick={clickNext}
        />
      </Tooltip>
    </div>
  );
};

const memoAudioPlayerCtrl = React.memo(AudioPlayerCtrl);
export { memoAudioPlayerCtrl as AudioPlayerCtrl };
