import styled from 'styled-components';

export const AudioPlayerControlBar = styled.div`
  width: 100%;
  height: 100%;
  position: relative;
  display: flex;
  justify-content: space-between;
  align-items: center;

  .icon {
    cursor: pointer;
    color: #615ced;

    &:hover {
      color: #7470e7;
    }
    &:active {
      color: #5b57ce;
    }
  }

  .loading {
    opacity: 0.5;
  }
`;

export const LeftControlBar = styled.div`
  min-width: 108px;
  display: flex;
  justify-content: space-between;
  align-items: center;

  .ant-tooltip {
    top: -10px !important;
    .ant-tooltip-inner {
      height: 28px;
      padding: 0;
      border-radius: 4px;
      padding: 4px 8px;
      font-size: 12px;
      line-height: 20px;
      display: flex;
      align-items: center;

      .icon {
        width: 15px;
        margin: 1px 0 0 2px;
      }
    }

    .ant-tooltip-arrow {
      display: none;
    }
  }
`;

export const PlayIconWrap = styled.div`
  min-width: 36px;
  min-height: 36px;
  display: flex;
  justify-content: center;
  align-items: center;
  background: #615ced;
  border-radius: 50%;
  cursor: pointer;

  &:hover {
    background: #7470e7;
  }
  &:active {
    background: #5b57ce;
  }
`;

export const SliderWrap = styled.div`
  width: 100%;
  height: 4px;
  margin: 0 14px 0 22px;
  position: relative;

  .cur_time,
  .total_time {
    position: absolute;
    top: 8px;
    color: var(--Text_Disabled);
    font-family: '苹方-简';
    font-size: 12px;
    font-weight: normal;
    line-height: 14px;
    letter-spacing: normal;
  }

  .cur_time {
    left: 0px;
  }

  .total_time {
    right: 0px;
  }

  .auddioPlayJumpTips {
    display: inline-block;
    height: 20px;
    line-height: 20px;
    padding: 0px 8px;
    border-radius: 4px;
    margin-left: 10px;

    background: rgba(25, 24, 49, 0.65);

    backdrop-filter: blur(8.16px);
    box-shadow: 0px 8px 32px 0px rgba(66, 66, 100, 0.12);
    color: #ffffff;
    font-size: 12px;
  }
`;

export const AudioWaveWrap = styled.div`
  width: 100%;
  height: 18px;
  position: absolute;
  top: -18px;
  left: 0px;
`;

export const PointBox = styled.div`
  position: relative;
  width: 100%;
  height: 4px;
  margin: 0 auto;
  cursor: pointer;

  .timeTooltipBox {
    position: absolute;
    bottom: 22px;
    z-index: 100;

    .arrow {
      position: absolute;
      bottom: -5px;
      left: 50%;
      background-color: var(--Fill_Brand_Inverse);
      width: 14px;
      height: 14px;
      transform: translateX(-50%) rotate(-45deg);
      border-radius: 2px;
    }
  }

  &:hover {
    .timeTooltipBox {
      display: block;
    }
  }

  .textBox {
    color: var(--Text_Brand_Primary);
    white-space: nowrap;
    background-color: var(--Fill_Brand_Inverse);
    border-radius: 12px;
    padding: 16px 20px;
    text-align: left;
    display: flex;
    flex-flow: column;
    line-height: 24px;
    font-size: 15px;
  }
`;

export const Bar = styled.div`
  position: relative;
  width: 100%;
  height: 4px;
  background-color: rgba(96, 92, 229, 0.2);

  .dotBar {
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    background: #aaa6ff;
  }

  .dot {
    position: relative;
    top: -13px;
    left: 0px;
    z-index: 5;
    width: 2px;
    min-height: 22px;
    background: #615ced;
    border-radius: 1px;
  }
`;

export const MarkWrap = styled.div`
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 4px;

  .markSegment {
    position: absolute;
    top: 0px;
    height: 4px;

    .markSegmentInner {
      margin: 0 2px;
      height: 100%;
      min-width: 4px;
      background: #bcbaff;
      position: relative;
    }

    .markSegmentProgress {
      position: absolute;
      height: 100%;
      top: 0;
      left: 0;
      background: #615ced;
    }
  }

  .hltMarkSegment {
    height: 6px;
  }

  .markSegment:hover {
    /* height: 12px; */
  }

  /* .markPoint {
    position: absolute;
    bottom: 0;
    height: 6px;
    width: 3px;
    border-radius: 1.5px 1.5px 0 0;
  }

  .hltMarkPoint {
    height: 10px;
  } */
`;

export const RightControlBar = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  min-width: 69px;

  .speed {
    min-width: 36px;
    min-height: 36px;
    display: flex;
    justify-content: center;
    align-items: center;
    color: var(--Text_Primary);
    cursor: pointer;
    background: rgba(39, 38, 77, 0);
    z-index: 100;
    -webkit-font-smoothing: antialiased;
    font-weight: 500;

    /* &:hover {
      color: #7470e7;
    }
    &:active {
      color: #5b57ce;
    } */
  }

  .control_icon {
    margin-left: 10px;
  }

  .ant-tooltip {
    top: -164px !important;
    .ant-tooltip-inner {
      width: 64px;
      height: 195px;
      padding: 0;
      box-shadow:
        0 3px 6px -4px rgba(39, 38, 77, 0.12),
        0 6px 16px 0 rgba(39, 38, 77, 0.08),
        0 9px 28px 8px rgba(39, 38, 77, 0.05);
      border-radius: 8px;
    }

    .ant-tooltip-arrow {
      display: none;
    }
  }

  .ant-popover {
    top: -65px !important;
    .ant-popover-inner {
      width: 215px;
      height: 96px;
      background-color: var(--Fill_Background_Light);
      box-shadow:
        0 3px 6px -4px rgba(39, 38, 77, 0.12),
        0 6px 16px 0 rgba(39, 38, 77, 0.08),
        0 9px 28px 8px rgba(39, 38, 77, 0.05);
      border-radius: 8px;
    }
  }
`;

export const SpeedSelect = styled.div`
  font-size: 14px;
  color: var(--Text_Primary);
  height: 100%;

  .select_item {
    height: 39px;
    display: flex;
    justify-content: center;
    align-items: center;
    cursor: pointer;
    z-index: 1;

    &:hover {
      color: #615ced;
    }
  }

  .select_active {
    color: #615ced;
  }
`;

export const VolumeContent = styled.div`
  display: flex;
  flex-direction: column;
  padding: 4px 16px;

  .skip_blank,
  .volume_bar {
    width: 100%;
    height: 44px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-family: PingFangSC-Regular, var(--font-family);
  }

  .VolumeContent {
    .ant-slider-handle:after {
      position: absolute;
      top: -6px;
      right: -6px;
      bottom: -6px;
      left: -6px;
      content: '';
    }
  }

  .skip_blank {
    font-size: 14px;
    color: var(--Text_Primary);

    .ant-switch {
      background: #dfdefa;
      transform: scale(0.75);

      &:focus {
        box-shadow: none;
        outline: none;
      }
    }
    .ant-switch-checked {
      background: rgba(96, 92, 229, 1);
    }
  }

  .volume_bar {
    font-size: 12px;
    color: rgba(39, 38, 77, 0.65);

    .ant-slider {
      width: 117px;

      .ant-slider-rail {
        background-color: var(--Fill_Background);
      }
      .ant-slider-track {
        background: var(--Fill_Brand_Primary);
      }

      .ant-slider-handle {
        width: 4px;
        height: 12px;
        margin-top: -4px;
        background-color: var(--Fill_Brand_Primary);
        border: solid 2px var(--Fill_Brand_Primary);
        border-radius: 4px;

        &:focus {
          box-shadow: none;
        }
      }
    }

    .ant-slider:hover .ant-slider-handle:not(.ant-tooltip-open) {
      border: solid 2px var(--Fill_Brand_Primary);
    }

    .volume {
      min-width: 31px;
      text-align: center;
    }
  }
`;

export const SelectNoneSpan = styled.span`
  user-select: none;
`;
