import { throttle } from 'lodash-es';
import MediaController from './MediaController';

class Audio {
  id = '';
  src = '';
  autoplay = false;
  volume = 1;
  muted = false;
  controls: any;

  playStatus = false;
  playbackRate = 1;
  currentTime = 0;
  duration = 0;
  skipBlank = false;

  _timeupdateCb: any = () => {
    const audio: any = this.getAudio();
    if (audio) {
      this.currentTime = audio.currentTime;
      this.timeupdateCb && this.timeupdateCb(audio.currentTime, this);
    }
  };

  _canplayCb: any = () => {
    const audio: any = this.getAudio();
    if (audio && !isNaN(audio.duration)) {
      this.duration = audio.duration;
      this.autoplay && audio.play();
      this.canplayCb && this.canplayCb(audio.duration);
    }
  };

  _endedCb: any = () => {
    const audio: any = this.getAudio();
    if (audio) {
      this.endedCb && this.endedCb(true);
    }
  };

  Plugins: any = { controls: false };
  timeupdateCb: any;
  canplayCb: any;
  endedCb: any;

  constructor(
    ele: HTMLElement,
    audioParams: any,
    model?: string,
    rssItemInfo?: any,
  ) {
    this.init(ele, audioParams, model, rssItemInfo);
  }

  onReady = (audioParams: any) => {
    const { id, autoplay, src, volume, muted, controls }: any = audioParams;
    this.id = id;
    this.src = src;
    this.autoplay = autoplay;
    this.volume = volume;
    this.muted = muted;
    this.controls = controls;
  };

  // 初始化音频播放器
  init = (
    ele: HTMLElement,
    audioParams: any,
    model?: string,
    rssItemInfo?: any,
  ) => {
    const { id, src, controls }: any = audioParams;

    let audio: any = document.getElementById(id);
    if (!audio) {
      audio = document.createElement('audio');
      audio.id = id;
      audio.src = src;
      audio.setAttribute('crossorigin', 'anonymous');
      audio.load();
      document.body.appendChild(audio);

      audio.addEventListener('timeupdate', this._timeupdateCb);
      audio.addEventListener('canplay', this._canplayCb);
      audio.addEventListener('ended', this._endedCb);
      audio.addEventListener('play', this.throttleOnPlay);
      audio.addEventListener('pause', this.throttleOnPause);
    }

    this.Plugins.controls = new MediaController(
      this,
      ele,
      controls,
      model,
      rssItemInfo,
    );

    this.onReady(audioParams);
  };

  // 获取音频播放器
  getAudio = () => {
    return document.getElementById(this.id);
  };

  // 销毁音频播放器
  onDestory = () => {
    const audio: any = this.getAudio();
    audio && document.body.removeChild(audio);
  };

  // 播放
  onPlay = () => {
    const audio: any = this.getAudio();
    if (audio) {
      this.playStatus = true;
      audio.play().catch((e: any) => {
        throw new Error(e);
      });
    }
  };

  // eslint-disable-next-line @typescript-eslint/member-ordering
  throttleOnPlay = throttle(this.onPlay, 200);

  // 暂停
  onPause = () => {
    const audio: any = this.getAudio();
    if (audio) {
      this.playStatus = false;
      audio.pause();
    }
  };

  // eslint-disable-next-line @typescript-eslint/member-ordering
  throttleOnPause = throttle(this.onPause, 200);

  // 改变音量
  onChangeVolume = (value: number) => {
    const audio: any = this.getAudio();
    audio.volume = value;
    this.volume = value;
  };

  // 静音
  onMuted = (value: boolean) => {
    const audio: any = this.getAudio();
    audio.muted = value;
    this.muted = value;
  };

  // 改变播放时间
  onChangePlayTime = (currentTime: number) => {
    const audio: any = this.getAudio();
    audio.currentTime = currentTime;
    this.currentTime = currentTime;
  };

  // 改变倍速xw
  onChangePlaybackRate = (value: number) => {
    const audio: any = this.getAudio();
    audio.playbackRate = value;
    this.playbackRate = value;
  };

  // 清除
  onClear = () => {
    const audio: any = this.getAudio();
    if (audio) {
      this.onPause();
      audio.src = '';
      audio.removeEventListener('timeupdate', this._timeupdateCb);
      audio.removeEventListener('canplay', this._canplayCb);
      audio.removeEventListener('ended', this._endedCb);
      audio.removeEventListener('play', this.throttleOnPlay);
      audio.removeEventListener('pause', this.throttleOnPause);
    }
  };

  // 清除事件
  removeAudioEventListener = () => {
    const audio: any = this.getAudio();
    if (audio) {
      audio.removeEventListener('timeupdate', this._timeupdateCb);
      audio.removeEventListener('canplay', this._canplayCb);
      audio.removeEventListener('ended', this._endedCb);
      audio.removeEventListener('play', this.throttleOnPlay);
      audio.removeEventListener('pause', this.throttleOnPause);
    }
  };

  // 切换音频链接
  onChangeSrc = (url: string, startTime = 0) => {
    const audio: any = this.getAudio();
    if (audio) {
      audio.src = url;
      audio.currentTime = startTime;
      audio.load();
    }
  };

  // 是否跳过空白片段
  onChangeSkipBlank = (skipBlank: boolean) => {
    this.skipBlank = skipBlank;
  };

  // 指定时间、监听时间的回调
  onSeek() {}
  onChangeTime() {}
  onChangePlayCbk() {}
  onChangeVolumeCbk() {}
  onChangeSpeedCbk() {}
  onChangeSkipBlankCbk() {}
}

export default Audio;
