import { Loading } from '../../../../../components/BaseCompontents/Loading';
import { docBigModelHooks } from '../../../../../documentModel';
import { eLabInfoStatus } from '../../../../../documentModel/docBigModel/docBigModel.type';
import { XMind } from '@tingwu/components';
import { Exception } from '@tingwu/design';
import React, { useEffect, useMemo, useRef, useState } from 'react';
import { XMindWrap } from './styled';

const MAX_LOOP_NUM = 50;

interface RecordXmindProps {
  height: number;
  isShow: boolean;
  isAiContentShow: boolean;
}
const RecordXmind: React.FC<RecordXmindProps> = ({
  height,
  isShow,
  isAiContentShow,
}) => {
  const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
  const { bigModelXmindInfo, bigModelXmindInfoStatus } =
    currentDocBigModelData || {};
  const countLoopNumberRef = useRef(0);

  const [firstReender, setFirstReender] = useState(false);

  useEffect(() => {
    if (isShow) {
      setFirstReender(true);
    }
  }, [isShow]);

  useEffect(() => {
    return () => {
      countLoopNumberRef.current = MAX_LOOP_NUM;
    };
  }, []);

  const hasMindMap = useMemo(() => {
    return !!bigModelXmindInfo?.json;
  }, [bigModelXmindInfo?.json]);

  const isLoading = useMemo(() => {
    return bigModelXmindInfoStatus === eLabInfoStatus.LOADING;
  }, [bigModelXmindInfoStatus]);

  if (!firstReender) return null;

  return (
    <XMindWrap>
      {isLoading && <Loading />}
      {!isLoading && (
        <>
          {hasMindMap ? (
            <XMind
              xmindData={JSON.stringify(bigModelXmindInfo?.json)}
              height={height}
              isAnimation={false}
              isBottom={isAiContentShow}
            />
          ) : (
            <div className="xMindWrapNoData">
              <Exception
                fullScreen
                showBtn={false}
                type="noData"
                title=""
                description={'暂无脑图'}
              />
            </div>
          )}
        </>
      )}
    </XMindWrap>
  );
};
export default RecordXmind;
