import { CommonUseSpeaker } from '@tingwu/core';
import { useCallback } from 'react';

import { docSpeakerHooks, docTagHooks } from '../../../../../../documentModel';
import { iDocSpeaker } from '../../../../../../documentModel/docSpeaker/docSpeaker.type';

import { AvatarForSpeaker } from '../../../../../../components/BaseCompontents/AvatarForSpeaker';

// 渲染发言人头像
const useRenderAvatar = () => {
  const {
    docSpeakerData,
    getSpeakerDataFromUid,
    // addUnknownDocSpeaker,
    getUnknownSpeakerAvatarUrl,
  } = docSpeakerHooks.useDocSpeakerData();
  const { docTagData } = docTagHooks.useDocTagData();

  // 渲染发言人头像
  const renderSpeakerAvatar = useCallback(
    (uid: string, size = 24) => {
      const foundSpeaker = getSpeakerDataFromUid(uid);
      // 没有发言人数据(延时后新增未知发言人)
      if (!docSpeakerData) return null;

      // 1. 发言人区分中
      if (docSpeakerData.speakersSplitIsLoading) {
        // 1.1 修改后的发言人，返回自定义头像
        if (foundSpeaker && foundSpeaker.name) {
          return <AvatarForSpeaker {...foundSpeaker} avatarSize={size} />;
        }

        // 1.2 返回发言人区分中头像
        return (
          <img
            src="https://img.alicdn.com/imgextra/i2/O1CN01j1zJ601ldECQqGWtH_!!6000000004841-54-tps-24-24.apng"
            alt="加载中头像"
          />
        );
      }

      // 2. 非发言人区分中
      // 2.1 有发言人数据，返回发言头像
      if (foundSpeaker) {
        return <AvatarForSpeaker {...foundSpeaker} avatarSize={size} />;
      }
      // 2.2 否则发言位置发言人头像
      return (
        // @ts-expect-error 不需要其他属性
        <AvatarForSpeaker
          speakerAvatar={getUnknownSpeakerAvatarUrl(uid)}
          avatarSize={size}
        />
      );
    },
    [docSpeakerData, docTagData?.roleSplitTip, getSpeakerDataFromUid],
  );

  // 渲染常用发言人头像
  const renderCommonSpeakerAvatar = useCallback(
    (_speaker: CommonUseSpeaker) => {
      const speaker: iDocSpeaker = _speaker as iDocSpeaker;
      return <AvatarForSpeaker {...speaker} avatarSize={24} />;
    },
    [],
  );

  return {
    renderSpeakerAvatar,
    renderCommonSpeakerAvatar,
  };
};

export { useRenderAvatar };
