import { useDataHooks } from '../../../../components/businessCommon/separateHooks/dataShare';
import {
  Provider as TranscriptionProvider,
  Transcription,
} from '@tingwu/transcription';
import { useCallback, useMemo } from 'react';
import { useRenderAvatar } from '../hooks/useRenderAvatar';

import { docSpeakerHooks } from '../../../../../../documentModel';
import { FileModel } from '../../../../utils/config';
import { getDefaultName } from '../../../../../../utils/speakerUtils';
import { Speaker } from '../types';

const Content = () => {
  const { controller, qnaController, aiAssistantController } = useDataHooks();
  /** 发言人相关 Start */
  const { docSpeakerData } = docSpeakerHooks.useDocSpeakerData();
  // 获取默认发言人名称
  const getDefaultSpeakerName = useCallback(
    (speaker?: Speaker) => {
      if (speaker) {
        const { speakersSplitIsOpen = false, speakersSplitIsLoading = false } =
          docSpeakerData || {};
        const speakersSplitOpen = speakersSplitIsLoading
          ? false
          : speakersSplitIsOpen;

        return getDefaultName(speaker.uid, speakersSplitOpen);
      }
      return '';
    },
    [docSpeakerData],
  );
  // 获取发言人列表
  const getAvailableSpeakersFromRedux = useCallback(() => {
    const speakers = (docSpeakerData?.speakersData || []).map((d) => ({
      ...d,
      bizUid: undefined,
    }));
    // console.log('speakerData:getAvailableSpeakersFromRedux', speakers);
    return speakers;
  }, [docSpeakerData]);
  // 渲染发言人头像
  const { renderSpeakerAvatar, renderCommonSpeakerAvatar } = useRenderAvatar();

  const transcriptionTheme = useMemo(
    () => ({
      editorFontFamily: 'var(--font-family)',
      transHorizontalPadding: 0,
      transVerticalPadding: 16,
    }),
    [],
  );

  /** Transcription 原子组件 */
  const transcription = (
    <TranscriptionProvider enableRecoilRoot controller={controller}>
      <Transcription
        className="tongyi_lixian"
        style={{ height: '100%' }}
        enableSelectAlibabaEmployee={false}
        aiAssistantController={aiAssistantController}
        /** 发言人相关 start */
        // 显示发言人
        enableShowSpeaker={true}
        // 发言人
        getDefaultSpeakerName={getDefaultSpeakerName}
        getAvailableSpeakers={getAvailableSpeakersFromRedux}
        renderAvatar={renderSpeakerAvatar}
        // 常用发言人
        renderCommonUseAvatar={renderCommonSpeakerAvatar}
        // extensions={[new MarkExtension()]}
        qnaController={qnaController}
        theme={transcriptionTheme}
        beforeCoverHeight={0}
        enableOfflineEditWordTip={false}
        renderAfter={undefined}
        showDropMenuMark={false}
      />
    </TranscriptionProvider>
  );

  /** 按需给出最终渲染结果 */
  controller.setShortcutPositioningButtonBottom(0);
  controller.setFileModel(FileModel.File);
  return transcription;
};

export default Content;
