import styled from 'styled-components';

export const LoadingWrapper = styled.div`
  --h: 40px; /* 容器高度 */
  --base-w: 656; /* 基准容器宽 */
  --base-scale: 0.5; /* 656 时显示为原图 50% */
  --img-w: 2880px; /* 原图宽 */
  --img-h: 1440px; /* 原图高 */
  --spin: 4s; /* 旋转时长修改为4秒 */
  --apng: 20px; /* 中心 APNG 尺寸 */
  --text-size: 14px; /* 文字大小 */
  --text-line-height: 24px; /* 文字行高 */
  --gap: 8px; /* 文字与 icon 的间距 */
  padding: 0px 32px 22px 32px;

  .loading-bar {
    position: relative;
    width: 100%; /* 父级决定容器宽度，这里自适应 */
    height: var(--h);
    overflow: hidden;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 6px;
  }

  /* 居中 + 按计算得到的 --scale 等比缩放 */
  .center-scale {
    position: absolute;
    left: 50%;
    top: 50%;
    transform-origin: center;
    transform: translate(-50%, -50%) scale(var(--scale, 0.5));
  }

  /* 内层只做旋转，不动缩放/居中 */
  .rotor {
    width: var(--img-w);
    height: var(--img-h);
    background: url('https://img.alicdn.com/imgextra/i3/O1CN01cRzLi71uzWG7aYwFo_!!6000000006108-2-tps-2880-1440.png')
      no-repeat 50% 50% / 100% 100%;
    animation: spin var(--spin) linear infinite;
  }

  .loading-bar__icon {
    position: absolute;
    left: 50%;
    top: 50%;
    width: var(--apng);
    height: var(--apng);
    transform: translate(-50%, -50%);
    pointer-events: none;
    background: url('https://img.alicdn.com/imgextra/i2/O1CN01M1X8yM1MWUC7u3Go5_!!6000000001442-54-tps-72-72.apng')
      no-repeat 50% 50% / 100% 100%;
  }

  .loading-bar__text {
    position: absolute;
    left: calc(50% + var(--apng) / 2 + var(--gap)); /* 文字位于 icon 右侧 */
    top: 50%;
    transform: translateY(-50%);
    color: white;
    font-size: var(--text-size);
    line-height: var(--text-line-height);
    text-shadow: 0px 1px 4px rgba(0, 0, 0, 0.08);
  }

  @keyframes spin {
    to {
      transform: rotate(360deg);
    }
  }
`;
