import {
  docBaseHooks,
  docBigModelHooks,
} from '../../../../../../documentModel';
import { ContentTabType } from '../../../../../../pages/docASR/utils/config';
import { contentTabActiveState } from '../../../../../../recoils/docFile/file';
import React, { memo, useEffect, useMemo, useRef, useState } from 'react';
import { useRecoilValue } from 'recoil';
import styled from 'styled-components';
import ContentTab, { ContentTabProps } from '../../common/ContentTab';
import RecordXmind from '../../RecordXmind';
import CustomPrompt from '../../WuLab/CustomPrompt';
import FileWulab from '../../WuLab/FileBigModel';
import { useInitQA } from '../../WuLab/QA/hooks/useInitQA.hooks';
import { ModelContentLoading } from '../modelContentLoading/index';

const RightContentContainer = styled.div`
  background-color: var(--Fill_Background_Light);
  height: 100%;
  position: relative;
`;

const RecordVisibleContainer = styled.div<{ isShow: boolean }>`
  height: 100%;
  width: 100%;
  display: ${({ isShow }) => (isShow ? 'block' : 'none')};
`;

const tabsList = [
  {
    title: '智能速览',
    type: ContentTabType.introduction,
  },
  {
    title: '思维导图',
    type: ContentTabType.mindmap,
  },
];

const RightContent: React.FC<{} & Omit<ContentTabProps, 'realTabsList'>> = memo(
  () => {
    const { currentDocBigModelData } = docBigModelHooks.useDocBigModelData();
    const { docBaseData } = docBaseHooks.useDocBaseData();
    const contentTabActive = useRecoilValue(contentTabActiveState);
    const { bigModelXmindInfo } = currentDocBigModelData || {};
    const [contentHeight, setContentHeight] = useState<number>(0);
    const wrapRef = useRef<HTMLDivElement>(null);
    useInitQA(true);
    useEffect(() => {
      if (wrapRef.current) {
        setContentHeight(wrapRef.current.clientHeight);
      }
    }, []);

    const content = useMemo(() => {
      switch (contentTabActive) {
        case ContentTabType.introduction:
          return <FileWulab />;
        case ContentTabType.prompt:
          return <CustomPrompt />;
      }
      return null;
    }, [contentTabActive]);

    const hasMindMap = useMemo(() => {
      return !!bigModelXmindInfo?.json;
    }, [bigModelXmindInfo?.json]);

    const filterTab = useMemo(() => {
      return tabsList.filter(
        (tab) =>
          (tab.type === ContentTabType.mindmap && hasMindMap) ||
          tab.type !== ContentTabType.mindmap,
      );
    }, [hasMindMap]);

    return (
      <RightContentContainer>
        <ContentTab realTabsList={filterTab} />
        <div
          style={{
            height: 'calc(100% - 52px)',
            position: 'relative',
            padding: '0px 1.5px',
          }}
          ref={wrapRef}
        >
          {!currentDocBigModelData?.allLoadFinished &&
            [1, 3].includes(docBaseData?.status as number) && (
              <ModelContentLoading />
            )}
          {content}
          <RecordVisibleContainer
            isShow={contentTabActive === ContentTabType.mindmap}
          >
            <RecordXmind
              height={contentHeight}
              isShow={contentTabActive === ContentTabType.mindmap}
              isAiContentShow={false}
            />
          </RecordVisibleContainer>
        </div>
      </RightContentContainer>
    );
  },
);

export default RightContent;
