import styled from 'styled-components';

export const LeftTopBarWrap = styled.div``;

export const IconButton = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  justify-content: space-between;
  position: relative;
  height: 32px;
  cursor: pointer;
`;

export const Label = styled.div`
  font-size: 14px;
  font-weight: 500;
  line-height: 24px;
  color: var(--Text_Primary);
  cursor: pointer;
`;

export const PopWindow = styled.div`
  position: absolute;
  top: 39px;
  right: 0px;
  z-index: 1130;
  user-select: none;
  background-color: var(--Fill_Background_Light);
  padding: 4px;
  border-radius: 12px;
  box-shadow: 0px 4px 6px 0px rgba(0, 0, 0, 0.08);
  border: 1px solid var(--Line_Secondary);
`;

export const Item = styled.div<{ selected: boolean }>`
  width: 141px;
  height: 32px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 4px 8px;
  color: var(--Text_Primary);
  background-color: ${(props) =>
    props.selected ? 'var(--Fill_Tertiary)' : 'transparent'};
  border-radius: ${(props) => (props.selected ? '2px' : '0px')};
`;
