import styled, { createGlobalStyle, keyframes } from 'styled-components';

export const EditorContentContainer = styled.div`
  height: 100%;
  .editorContentBottom {
    display: flex;
    /* padding-right: 32px; */
    justify-content: center;
    font-size: 14px;
    overflow: hidden;
    .editorContentBottomLeft {
      display: flex;
      flex-direction: column;
      flex-grow: 1.2;
      flex-basis: 0;
      flex-shrink: 0;
      overflow-y: auto;
      overflow-x: hidden;
      position: relative;
      /* padding-left: 32px;
      padding-right: 32px; */
      min-width: 376px;

      .goldplay__screen--poster {
        width: 100% !important;
        height: 100% !important;
      }
    }
    .editorContentBottomRight {
      flex-grow: 1;
      flex-basis: 0;
      flex-shrink: 0;
      max-width: 434px;
      background-color: var(--Fill_Background_Light);
      border-radius: 8px;
      position: relative;
      .placeholderDiv {
        height: 16px;
      }
      .wulabBackground {
        width: calc(100% - 4px);
        min-height: 158px;
        max-height: 158px;
        position: absolute;
        pointer-events: none;
      }
    }
  }
  .editorContentBottom :focus-visible {
    outline: none !important; /* 或者使用您希望的边框、阴影等样式 */
  }
  .editorContentBottomLeftContent {
    height: calc(100% - 48px);
    overflow: overlay;
    overflow-x: hidden;
    flex-grow: 1;
    flex-basis: 0;
    flex-shrink: 0;
    .tignwu2_paragraphStyled {
      border-radius: 8px;
      .tingwu2_paragraphTranslate {
        border-bottom-left-radius: 8px;
        border-bottom-right-radius: 8px;
      }
      .tingwu2_paragraphTranslate_showOrigin {
        border-radius: 8px;
      }
    }
  }
`;
const showSlowly = keyframes`
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
`;
const top2Bottom = keyframes`
  0% {
    transform: translateY(-89px);
  }

  100% {
    transform: translateY(0);
  }
`;
const top2BottomEditor = keyframes`
  0% {
    transform: translateY(-28px);
  }

  55% {
    transform: translateY(4px);
  }

  100% {
    transform: translateY(0);
  }
`;
// 详情页 动画class
export const FileAnimationStyle = createGlobalStyle`
  /* 左侧工具栏 */
  .file-left-tools {
    animation: ${showSlowly} 0.3s;
  }

  /* 顶部工具栏 */
  .file-top-tools {
    animation: ${showSlowly} 0.3s;
  }

  /* 原文区 */
  .editorContentBottom {
    animation: ${showSlowly} 0.3s 50ms, ${top2Bottom} 0.3s 50ms;
  }

  .editorViewport {
    animation: ${showSlowly} 0.3s, ${top2BottomEditor} 0.5s;
  }
`;
