import { documentModelNS } from '../documentModel/document.baseType';
import { iDocumentModel, iDocumentState } from '../documentModel/document.type';

import { docBaseModel } from '../documentModel/docBase';
import { docBigModelModel } from '../documentModel/docBigModel';
import { docPlayerModel } from '../documentModel/docPlayer';
import { docRouteModel } from '../documentModel/docRoute';
import { docSpeakModel } from '../documentModel/docSpeaker';
import { docTagModel } from '../documentModel/docTag';
import { docTextPolishModel } from '../documentModel/docTextPolish';
import { docTranslateModel } from '../documentModel/docTranslate';
import {
  documentEffects,
  documentReducers,
} from '../documentModel/document.operator';

// 初始化状态
const documentModelInitState: iDocumentState = {
  namespace: documentModelNS,
  docRouteData: docRouteModel.state,
  docBaseDataMap: docBaseModel.state,
  docTagDataMap: docTagModel.state,
  docSpeakerDataMap: docSpeakModel.state,
  docBigModelDataMap: docBigModelModel.state,
  docTranslateDataMap: docTranslateModel.state,
  docPlayerDataMap: docPlayerModel.state,
  docTextPolishMap: docTextPolishModel.state,
};

// 整体文档模型
const documentsModel: iDocumentModel = {
  namespace: documentModelNS,
  state: documentModelInitState,
  reducers: {
    ...documentReducers,
    ...docRouteModel.reducers,
    ...docBaseModel.reducers,
    ...docTagModel.reducers,
    ...docSpeakModel.reducers,
    ...docBigModelModel.reducers,
    ...docTranslateModel.reducers,
    ...docPlayerModel.reducers,
    ...docTextPolishModel.reducers,
  },
  effects: {
    ...documentEffects,
    ...docRouteModel.effects,
    ...docBaseModel.effects,
    ...docTagModel.effects,
    ...docSpeakModel.effects,
    ...docBigModelModel.effects,
    ...docTranslateModel.effects,
    ...docPlayerModel.effects,
    ...docTextPolishModel.effects,
  },
};

export default documentsModel;
