import { iDocumentState } from '../document.type';

import * as documentActions from './document.actions';

// Document Reducers
export const documentReducers = {
  // 更新 document 公用数据
  updateDocument: (state: iDocumentState, { payload }) => {
    return {
      ...state,
      ...payload,
    };
  },
  // 更新 Document 公用数据数据
  updateDocumentCurtDataReducer: (
    state: iDocumentState,
    action: ReturnType<typeof documentActions.updateDocumentCurtDataAction>,
  ) => {
    const { docId } = state;
    const {
      docId: dataDocId,
      forceUpdate = false,
      docScene,
      docErrorCode,
    } = action.payload;
    // 数据更新条件：1.初始化(没有 DocId) 2.强制更新 3.docId 相同
    if (!docId || forceUpdate || dataDocId === docId) {
      if (dataDocId !== undefined) state.docId = dataDocId;
      if (docScene !== undefined) state.docScene = docScene;
      if (docErrorCode !== undefined) state.docErrorCode = docErrorCode;
    }

    return state;
  },
  clearDocumentDataReducer: (state: iDocumentState) => {
    return {
      ...state,
      docId: undefined,
      docScene: undefined,
      docFileType: undefined,
      docErrorCode: undefined,
      docNoteData: undefined,
      docBaseDataMap: {},
      docTagDataMap: {},
      docSpeakerDataMap: {},
      docBigModelDataMap: {},
      docTranslateDataMap: {},
      docPlayerDataMap: {},
      docTextPolishMap: {},
    };
  },
};
