import type { Action } from '../document.baseType';
import { namespacePrefix } from '../document.baseType';
import { iDocumentState } from '../document.type';

// 更新 Document 公用数据
export const updateDocumentCurtDataAction = (
  payload: Pick<
    iDocumentState,
    'docId' | 'docScene' | 'docErrorCode' | 'docFileType'
  > & {
    forceUpdate?: boolean;
  },
  isHooks = false,
) => ({
  type: namespacePrefix('updateDocumentCurtDataReducer', isHooks),
  payload,
});

// 重置 Document 文档全部数据
export const clearDocumentDataAction = (isHooks = false): Action<null> => ({
  type: namespacePrefix('clearDocumentDataReducer', isHooks),
  payload: null,
});
