import { eAPIStatus, iDocIDType } from '../document.baseType';

// 翻译数据模型
export interface iDocTranslateData {
  // 翻译状态
  translateIsOpen?: boolean; // 翻译是否开启
  translateSourceLanguage?: number; // 翻译源语言:  1 | 2 | 3 | 4 | 5; 1中文 2英语 3粤语 4中英文自由说 5日语
  translateTargetLanguage?: number; // 翻译语言: 0 | 1 | 2 | 5; 0不翻译 1中文 2英语 5日语
  translateDisplayMode?: number; // 翻译模式: 2 双语; 1 纯译文(默认双语展示)
  translateIsLoading?: boolean; // 翻译是否加载中
  translationLang?: string; // 【分享专用】翻译状态： 目标语言_展示模式 | 展示模式
  translateBigModelTargetLoading?: number; // 大模型翻译加载状态 0 | 1 | 2 | 3  0加载中 1加载成功 2 加载失败  -1 无需关心，为中断加载状态
  translateOriginTargetLoading?: number; // 原文翻译加载状态 0 | 1 | 2 | 3  0加载中 1加载成功 2 加载失败  -1 无需关心，为中断加载状态
  // 1. 用于自动加载提示
  translateIsServerLoading?: boolean; // 表示翻译服务端保存的状态是翻译中，查询完成需要手动提示
  translateServerLoadingStatus?: eAPIStatus; // 服务端加载状态

  // 原文区翻译内容
  originTranslate?: {
    pg: Array<{
      pi: string;
      // API dataTransfer txt 转为 tc, 删除掉了 txt
      ts: Array<{ bt: number; et: number; si: number; tc: string }>;
    }>;
  };
  // 内容盒子 原文区翻译原始数据
  translatedDocInfo?: iTranslatedDocInfo;
  // 大模型翻译结果
  bigModelTranslate?: {
    keyWordsExtractor?: iBigModelTranslateBase[]; // 关键词
    actionExtractor?: iBigModelTranslateBase[]; // 智能代办
    fullSummary?: iBigModelTranslateBase[]; // 全文摘要
    pptSummary?: iBigModelTranslateBase[]; // PPT摘要
    agendaSummary?: any[]; // 议程摘要
    titleGenerator?: any[]; // 章节速览标题
    roleSummary?: iBigModelTranslateBase[]; // 发言总结
    questionAnswerLlm?: any[]; // QA
    pptTitle?: any[]; // PPT 标题
  };
}
// 大模型翻译结果基础类型
export interface iBigModelTranslateBase {
  id: number; // 🆔标识
  value: string; // 翻译结果
}

// 翻译Tag: API 返回数据
export interface iDocTranslateApiTag {
  translateSwitch?: string; // 翻译是否开启
  translateLoading?: string; // 翻译是否加载中
  translateLanguageConf?: string; // 翻译模式
  originLanguageValue?: string; // 翻译源语言
  transTargetValue?: string; // 翻译目标语言
}

/** 内容盒子 */
/** 内容盒子原文翻译返回原始数据 */
export interface iTranslatedDocInfo {
  // 原文翻译JSON信息
  docVersion?: string; // 文档版本
  sourceLanguage: string; // 原始语言 （不建议使用，推荐tag）
  targetLanguage: string; // 目标语言 （不建议使用，推荐tag）
  status?: string; // 状态 completed （无需使用）
  transId?: number; // 纪要ID
  contentId?: string; // 盒子ID
  userId?: number; // 用户ID
  translatedDoc: string; // 翻译原文 （不建议使用，推荐 originTranslate）
}

// 存储的翻译数据
export type iDocTranslateDataMap = Record<iDocIDType, iDocTranslateData>;
