import {
  documentModelNS,
  iDocDataUpdateBasePayload,
} from '../../document.baseType';

import { iDocTranslateData } from '../docTranslate.type';

/** Reducer Actions */
// 整体翻译数据更新
export const updateDocTranslateDataAction = (
  payload: iDocDataUpdateBasePayload<iDocTranslateData>,
) => ({
  type: 'updateDocTranslateDataReducer',
  payload,
});
// 更新部分翻译内容
export const updateDocTranslatePartialDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocTranslateData>>,
) => ({
  type: 'updateDocTranslatePartialDataReducer',
  payload,
});

/** Effect Actions */
// 初始化翻译数据
export const initDocTranslateDataAction = (
  payload: iDocDataUpdateBasePayload<null>,
) => ({
  type: 'initDocTranslateDataEffect',
  payload,
});

// 更新翻译目标语言
export const changeDocTranslateTargetAction = (
  payload: iDocDataUpdateBasePayload<number>,
) => ({
  type: `${documentModelNS}/changeDocTranslateTargetLangEffect`,
  payload,
});
// 更新翻译译文展示模式
export const changeDocTranslateDisplayAction = (
  payload: iDocDataUpdateBasePayload<number>,
) => ({
  type: `${documentModelNS}/changeDocTranslateDisplayEffect`,
  payload,
});

// 更新部分翻译内容
export const updateDocTranslatePartialQueryDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocTranslateData>>,
) => ({
  type: `${documentModelNS}/updateDocTranslatePartialData`,
  payload,
});
