import { eDocFileType, iDocIDType } from '../document.baseType';

// 发言人区分 Tag 状态
export enum eDocSpeakerSplitStatus {
  serverClosed = -1, // 服务器关闭
  close = 0, // 未开启发言总结
  open = 1,
  spliting = 2,
  result = 3,
}
// 创建副本视频 1同步中 2完成 3失败
export enum eSyncingMediaStatus {
  Syncing = '1',
  Done = '2',
  Failed = '3',
}

// DocTag 类型
export interface iDocTagData {
  initDotReady?: boolean; // 离线小红点：wulab总按钮，全文概要，章节速览; string -> boolean
  read: 0 | 1; // 是否已读; string -> number
  // 媒体相关 Tag
  mediaTag: {
    // json ->
    skipBlank: boolean; // 是否跳过空白片段
    subtitle: boolean; // 是否显示字幕
    subtitleSpeaker: boolean; // 是否显示字幕发言人
    subtitlesModel?: 'dark' | 'light';
  };
  // 文件类型
  fileType: eDocFileType; // 转写文件类型
  showName?: string; // 转写文件名称
  // 翻译相关 Tag
  translateLoading: number; // 翻译是否加载中; string -> number
  translateLanguageConf: number; // 翻译显示配置; string -> number
  translateSwitch: number; // 翻译是否开启; string -> number
  originLanguageValue: number; // 翻译源语言; string -> number
  transTargetValue: number; // 翻译目标语言; string -> number
  // 发言人相关 Tag
  identify?: string; // 发言人区分 Map 数据
  roleSplitTip?: eDocSpeakerSplitStatus; // 发言人区分状态: 0 关闭, 1打开, 2区分中, 3有结果; string -> number
  roleSplitNum?: number; // 发言人数量: -1:不体验, 0:多人, 2:2人, 3默认值; 100:实时智能区分发言人 string -> number
  // QA 问答相关 Tag
  QASwitchStatus: number; // QA 问答是否开启; string -> number
  // 新手引导相关
  pptDotVisible: 0 | 1; // ; string -> number
  pptMessageVisible: 0 | 1; // ; string -> number
  // TODO: 待确认
  shareQASwitchStatus: number; // ; string -> number
  // AI改写相关 Tag
  textPolishSwitch: number; // 是否打开了AI改写标签，0关闭，1打开 ; string -> number
  textPolishLanguageConf: number; // 展示模式：1仅显示改写结果，2原文+改写结果 ; string -> number
  // 批量摘取相关Tag
  copySpeakersCheck: number; // 是否摘取发言人 0 不摘取 1摘取; string -> number
  copyTimeCheck: number; // 是否摘取时间 0 不摘取 1摘取; string -> number
  syncingMedia: eSyncingMediaStatus; // 创建副本视频 1同步中 2完成 3失败
  audioStatus?: string | number; // 音频是否生成，0:未生成；1:已生成
  status?: number;
  errorCode?: string;
}

// 存储 Tag 数据类型
export type iDocTagDataMap = Record<iDocIDType, iDocTagData>;
