// DocTag Actions
import {
  iDocDataUpdateBasePayload,
  namespacePrefix,
} from '../../document.baseType';

import { iDocTagData } from '../docTag.type';

export const updateAudioStatus = (
  payload: iDocDataUpdateBasePayload<iDocTagData>,
) => ({
  type: namespacePrefix('updateDocTagDataReducer', true),
  payload,
});

/** Reducer Actions */
export const updateDocTagDataAction = (
  payload: iDocDataUpdateBasePayload<iDocTagData>,
) => ({
  type: 'updateDocTagDataReducer',
  payload,
});

// 更新部分翻译内容
export const updateDocTagPartialDataAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocTagData>>,
) => ({
  type: 'updateDocTagPartialDataReducer',
  payload,
});

/** Effect Actions */
export const initDocTagDataAction = (
  payload: iDocDataUpdateBasePayload<any>,
) => ({
  type: 'initDocTagDataEffect',
  payload,
});

// 更新 DocTag
export const updateDocTagAndSyncTagAction = (
  payload: iDocDataUpdateBasePayload<Partial<iDocTagData>>,
) => ({
  type: 'updateDocTagEffect',
  payload,
});
