import { useMemo } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { iDocumentState } from '../document.type';

// DocTag Hooks
const useDocTagData = () => {
  const dispatch = useDispatch();
  // redux 取数
  const { docId, docTagDataMap } = useSelector(
    (state: { documentModel: iDocumentState }) => ({
      docId: state.documentModel.docId,
      docTagDataMap: state.documentModel.docTagDataMap,
    }),
  );

  // 当前文档Tag数据
  const docTagData = useMemo(() => {
    if (!docId) return undefined;
    return docTagDataMap[docId];
  }, [docId, docTagDataMap]);

  return {
    // data
    docTagData,
  };
};

export { useDocTagData };
