import { iDocumentState } from '../../document.type';

import * as docSpeakerActions from './docSpeaker.actions';

// DocSpeaker Reducers
export const docSpeakerReducers = {
  // 初始化发言人数据
  initDocSpeakerDataReducer(
    state: iDocumentState,
    action: ReturnType<
      typeof docSpeakerActions.initDocSpeakerDataReducerAction
    >,
  ) {
    const { docId, data } = action.payload;
    const docSpeakerData = data!;
    // 更新发言人数据
    const _docSpeakerData = { [docId]: docSpeakerData };
    return {
      ...state,
      ...{
        docSpeakerDataMap: { ...state.docSpeakerDataMap, ..._docSpeakerData },
      },
    };
  },
};
