import { iDocumentState } from '../../document.type';

import * as docRouteActions from './docRoute.actions';

// DocRoute Reducers
export const docRouteReducers = {
  // 更新路由数据
  updateRouteDataReducer: (
    state: iDocumentState,
    action: ReturnType<typeof docRouteActions.updateRouteDataAction>,
  ) => {
    // 更新数据
    state.docRouteData = action.payload;

    return state;
  },
  // 兼容老路由数据
  updateOldShareRouteDataReducer: (
    state: iDocumentState,
    action: ReturnType<typeof docRouteActions.updateOldShareRouteDataAction>,
  ) => {
    // 更新数据
    (state.docRouteData as any).oldShare = action.payload;
    return state;
  },
};
