import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { iDocumentState } from '../document.type';

import { docRouteActions } from './docRoute.operator';
import { iDocRouteData } from './docRoute.type';
/**
 * DocRoute Hooks
 * @param forceUpdate 是否强制更新
 * @returns
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const useDocRouteData = (forceUpdate = false) => {
  const dispatch = useDispatch();
  // 已存储的数据
  const docRouteData = useSelector(
    (state: iDocumentState) => state.docRouteData,
  );

  // 普通路由初始化
  const initRouteData = useCallback(async () => {
    return (await dispatch(
      docRouteActions.initRouteDataAction(),
    )) as unknown as Awaited<iDocRouteData>;
  }, [dispatch]);

  return {
    // data
    docRouteData,
    // data function
    initRouteData,
  };
};

export { useDocRouteData };
