import * as docBigModelActions from './docBigModel.actions';
// *** 数据处理相关 ***
import { normalizeBigModelData } from './docBigModel.dataTransfer';
// *** 类型定义相关 ***
import { iDocBaseData } from '../../../documentModel/docBase/docBase.type';
import { iDocTranslateData } from '../../../documentModel/docTranslate/docTranslate.type';
import type { EffectsCommandMap } from 'dva-core';
import { iDocumentState } from '../../document.type';
import { type iDocBigModelData } from '../docBigModel.type';

export const docBigModelEffects = {
  // 统一初始化大模型相关数据
  *initBigModelDataEffect(
    action: ReturnType<typeof docBigModelActions.initDocBigModelDataAction>,
    { put }: EffectsCommandMap,
  ) {
    const { docId, docScene } = action.payload;
    const params = {
      docId,
      docScene,
    };
    // const { isVideo } = docBaseData || {};
    yield put(docBigModelActions.initDocBigModelNormalDataAction(params));
  },

  // 初始化大模型数据(除PPT 信息)
  *initBigModelNormalDataEffect(
    action: ReturnType<
      typeof docBigModelActions.initDocBigModelNormalDataAction
    >,
    { put, call, select }: EffectsCommandMap,
  ) {
    const { docId, docScene } = action.payload;
    const {
      docBaseData,
      prevDocBigModelData,
    }: { docBaseData: iDocBaseData; prevDocBigModelData: iDocBigModelData } =
      yield select((state: { documentModel: iDocumentState }) => ({
        docBaseData: state.documentModel.docBaseDataMap[docId],
        prevDocBigModelData: state.documentModel.docBigModelDataMap[docId],
      }));
    const { speakSummaryStatus: prevSpeakSummaryStatus } =
      prevDocBigModelData || {};
    //  *** 前置处理 ****
    // 更新加载中标识
    yield put(
      docBigModelActions.updateDocBigModelDataAction({
        docId,
        docScene,
        data: {
          normalLabInfoLoading: true,
        },
      }),
    );

    // while (true) {
    // }
    //  *** step1: 获取大模型数据
    const data = docBaseData.bigModelData;
    // *** step2: 归一化服务端返回的数据
    const normalizedData = normalizeBigModelData(data);
    // *** step3: 更新大模型数据
    yield put(
      docBigModelActions.updateDocBigModelDataAction({
        docId,
        docScene,
        data: {
          ...normalizedData,
          normalLabInfoLoading: false,
        },
      }),
    );
    // *** step4: 判断对应信息是否已经完成未完成需要继续轮询对应的数据
    const {
      docBigModelData,
      docTranslateData,
    }: {
      docBigModelData: iDocBigModelData;
      docTranslateData: iDocTranslateData;
    } = yield select((state: { documentModel: iDocumentState }) => {
      return {
        docBigModelData: state.documentModel.docBigModelDataMap[docId],
        docTranslateData: state.documentModel.docTranslateDataMap[docId],
      };
    });
    const { docId: newDocId } = yield select(
      (state: { documentModel: iDocumentState }) => {
        return {
          docId: state.documentModel?.docId,
        };
      },
    );

    // *** Step5: 存在数据未加载完成需要继续轮询结果
    if (
      newDocId &&
      newDocId === docId &&
      docBigModelData.normalLabInfoLoading
    ) {
      yield put(
        docBigModelActions.initDocBigModelNormalDataAction({ docId, docScene }),
      );
      return;
    }
    // *** Step6: 加载完成更新数据
    yield put(
      docBigModelActions.updateDocBigModelDataAction({
        docId,
        docScene,
        data: {
          normalLabInfoLoading: false,
        },
      }),
    );
  },
};
