import { eDocScene } from '../document.baseType';
import { iDocBaseData, iTransResultData } from './docBase.type';

import { iDocPlayerData } from '../docPlayer/docPlayer.types';

// 获取 DocBase 上的 Tag
export const getDocBaseTag = (docBaseData: iDocBaseData) => {
  if ((docBaseData as iTransResultData).tag) {
    return (docBaseData as iTransResultData).tag;
  }
};

// 获取播放器相关数据
export const getDocPlayerData = (
  docBaseData: iDocBaseData,
  docScene: eDocScene,
) => {
  let basePlayerData: Pick<
    iDocPlayerData,
    'videoUrl' | 'videoPoster' | 'audioUrl' | 'audioSegments' | 'audioSpectrum'
  > & {
    isVideo: boolean;
  } = {
    isVideo: false,
    videoUrl: '',
    videoPoster: '',
    audioUrl: '',
    audioSegments: [],
    audioSpectrum: [],
  };

  // 纪要、纪要分享
  if ([eDocScene.trans, eDocScene.transShare].includes(docScene)) {
    const {
      isVideo,
      videoUrl,
      videoPoster,
      playback,
      audioSegments,
      spectrum = [],
    } = docBaseData as iTransResultData;
    basePlayerData = {
      isVideo,
      videoUrl,
      videoPoster,
      audioUrl: playback,
      audioSegments,
      audioSpectrum: spectrum,
    };
  }

  return basePlayerData;
};

// 基础数据转为 TransResultData
export const getTransResultDataFromDocBase = (
  docBaseData: iDocBaseData,
): iTransResultData => {
  return docBaseData as iTransResultData;
};
