// DocBase 类型
import {
  eDocFileType,
  eTranscriptionLanguage,
  eVideoQuality,
  iDocIDType,
} from '../document.baseType';

// 原文数据类型
export interface iDocTransResult {
  pg: Array<{
    pi: string;
    ui: string;
    sc: Array<{
      bt: number;
      et: number;
      id: number;
      si: number;
      tc: string;
    }>;
  }>;
}

// Discovery/Trans 通用数据
export interface iDocBaseCommonTagData {
  read: 0 | 1; // 是否已读; string -> number
  showName: string; // 展示名称
  fileType: eDocFileType; // 转写文件类型
  hasPPT: boolean; // 是否有 PPT; string -> number
  hasNote: boolean; // 是否有 笔记; string -> boolean
  // FIXME: 发言人
  enableSpokenToWritten: 0 | 1; // 是否启用发言人区分; string -> number
  roleSplitNum: -1 | 0 | 1; // 发言人区分? ; string -> number
  roleSplitTip: 0 | 1; // 发言人区分? ; string -> number
  identify?: string; // 发言人MAP
  // 翻译
  lang: eTranscriptionLanguage; // 转写语言
  translateSwitch: number; // 翻译是否开启; "[0|1]"; string -> number
  originLanguageValue?: number; // 翻译源语言; "[1|2|3|4|5]", 内容盒子无; string -> number
  transTargetValue?: number; // 翻译目标语言; "[0|1|2|3|4|5]", 内容盒子无; string -> number
  translateLanguageConf?: number; // 翻译配置; "[2|1]", 内容盒子无; string -> number
  originalTag: {
    // "{\"isVideo\":1}" string -> { isVideo: 1 }
    isVideo: 0 | 1;
  };
  // AI原文改写
  textPolishSwitch?: number; // 是否打开了AI改写标签
  textPolishLanguageConf?: number; // 显示：1仅显示改写结果，2原文+改写结果
  // 暂未用到
  paasLabScene: string;
  enableIdentify: string;
  client: string;
  pptPdfFile?: string;
  fileFormat?: string;
  source?: string;
  isVideo: boolean;
  audioStatus?: number;
}
export interface iDocBaseCommonData {
  transId: string | number; // 转写ID(内容盒子number, 纪要string)
  duration: number; // 时长
  fileSize: number; // 文件大小
  playback: string; // 音频回放地址
  audioSegments: number[][]; // 音频片段(跳过空白片段)
  spectrum?: number[]; // 音频频谱
  playVideoCode?: string; // 视频失败原因
  result: string; // 原文数据
  tag: iDocBaseCommonTagData;
  wordCount?: number; // 字数统计?
  userId?: number; // 创作者用户 ID
  status?: number; // 状态
  transcriptionLoading?: boolean;
}

/** 文件转写数据模型 */
export interface iTransResultData extends iDocBaseCommonData {
  checkStatus?: number;
  transId: iDocIDType; // 转写 ID
  scene: 0 | 1 | 2; // 纪要查看场景: 0[个人编辑]、1[登录查看分享]、2[未登录查看分享]
  userId?: number; // 创作者用户 ID
  username?: string; // 创作者用户名
  taskId: string; // PaaS 任务 ID
  status: number; // 状态
  collectStatus: 0 | 1; // 是否已收藏
  allowSave: boolean; // 是否允许保存
  contentCheck: number; // 是否通过绿网审核
  shareContentCheck: number; // 分享是否通过绿网检测
  showTime?: number; // 展示时间戳
  transStartTime?: number; // 转写开始时间戳
  forecastTransDoneTime?: number; // 预测转写完成时间戳
  playVideoUrl: string; // 视频播放地址
  videoFrameUrl?: string; // 视频海报地址
  dir: { dirId: number }; // 目录
  rssItemInfo?: {};
  rssInfo?: {};
  ongoingMeetingId?: number; // 未完成的实时转写 ID
  // 云盘相关信息
  aliyunDriveVideoPreviewPlayInfo?: {
    // 播放地址
    live_transcoding_task_list: Array<{
      template_id: eVideoQuality; // 视频清晰度
      url: string; // m3u8 地址
      // 其他暂未用到
      template_name: string;
      template_height: string;
      stage: string;
      template_width: string;
      status: string;
    }>;
    // 暂未用到
    meta: {
      duration: number;
      width: number;
      height: number;
    };
    category: string;
  };
  // 暂未用到?
  yakeWordsStatus?: number;
  /** 处理后的数据 */
  isVideo: boolean; // 是否视频转写（非接口数据）
  videoUrl?: string; // 视频播放地址
  videoPoster?: string; // 视频海报地址
  audioStatus?: number; // 音频是否生成，0:未生成；1:已生成
  translatedDoc?: any;
  textPolishedDoc?: any;
  bigModelData?: any;
  consoleInfo?: any;
}

/** DocBase 数据模型 */
export type iDocBaseData = iTransResultData;

/** 存储数据模型 */
export type iDocBaseDataMap = Record<iDocIDType, iDocBaseData>;

// 转写结果段落数据类型
export interface ITransParagraph {
  pi: string; // parapgrph_id，段落唯一标识，19位，13位录音创建时间戳 + 6位数字
  ui: string; // user_id，用户ID，0代表未检查到的用户
  sc: ITransToken[];
}

// token数据类型
export interface ITransToken {
  id: number;
  bt: number;
  et: number;
  tc: string;
  si: number;
}

export interface fileControlPayload {
  docEditParams: {
    value: string;
  };
  docResultParams: {
    content: {
      pg: ITransParagraph[];
    };
  };
  content: {
    pg: ITransParagraph[];
  };
  collectStatus: number;
  type: 0 | 1 | 2;
  dirId: number;
  code: string;
  status: boolean;
  title: string;
}

export interface SentenceInfo {
  beginTime: number;
  endTime: number;
  paragraphId: string;
  sentenceText: string;
}

export interface Word {
  sentenceId: number;
  start?: number | null;
  end?: number | null;
  text: string;
}

export interface Paragraph {
  paragraphId: string;
  words: Word[];
}

export interface Transcription {
  paragraphs?: Paragraph[];
}
